﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户资料
    /// </summary>
    [TableName("spb_UserProfiles")]
    [PrimaryKey("UserId", autoIncrement = false)]
    [CacheSetting(true, ExpirationPolicy = EntityCacheExpirationPolicies.Usual)]
    [Serializable]
    public class PointTaskUserInfo : IEntity
    {
        /// <summary>
        ///UserId
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        ///性别1=男,2=女,0=未设置
        /// </summary>
        public GenderType Gender { get; set; }

        /// <summary>
        ///生日类型1=公历,2=阴历
        /// </summary>
        public BirthdayType BirthdayType { get; set; }

        /// <summary>
        ///公历生日
        /// </summary>
        public DateTime Birthday { get; set; }

        /// <summary>
        ///阴历生日
        /// </summary>
        public DateTime LunarBirthday { get; set; }

        /// <summary>
        ///所在地
        /// </summary>
        public string NowAreaCode { get; set; }

        /// <summary>
        ///QQ
        /// </summary>
        public string QQ { get; set; }

        /// <summary>
        ///证件类型
        /// </summary>
        public CertificateType CardType { get; set; }

        /// <summary>
        ///证件号码
        /// </summary>
        public string CardID { get; set; }

        /// <summary>
        ///自我介绍
        /// </summary>
        public string Introduction { get; set; }

        /// <summary>
        /// 资料完整度（0至100）
        /// </summary>
        public int Integrity { get; set; }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.UserId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}