﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户领取积分任务记录 数据库仓储接口
    /// </summary>
    public interface IPointTaskRecordRepository : IRepository<PointTaskRecord>
    {
        /// <summary>
        /// 获取积分任务领取记录列表
        /// </summary>
        /// <param name="taskRecordStatus">领取状态</param>
        /// <param name="taskId">任务Id</param>
        /// <param name="userId">用户Id</param>
        /// <param name="pageSize">页面大小</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        PagingDataSet<PointTaskRecord> GetRecords(TaskRecordStatus? taskRecordStatus = null, long taskId = 0, List<string> userId = null, int pageSize = 20, int pageIndex = 1);

        /// <summary>
        /// 根据任务ID删除任务领取记录
        /// </summary>
        /// <param name="taskId"></param>
        void DeleteTasktoUserByTaskId(long taskId);

        /// <summary>
        /// 获取积分任务领取记录列表
        /// </summary>
        /// <param name="taskRecordStatus">领取状态</param>
        /// <param name="taskId">任务Id</param>
        /// <param name="userId">用户Id</param>
        /// <returns></returns>
        PointTaskRecord GetRecordsBy(TaskRecordStatus? taskRecordStatus = null, long taskId = 0, long userId = 0);

    }
}