﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分任务数据库仓储接口
    /// </summary>
    public interface IPointTaskRepository : IRepository<PointTask>
    {
        /// <summary>
        /// 获取积分任务列表
        /// </summary>
        /// <param name="pointTaskStatus">积分任务状态</param>
        /// <returns></returns>
        IEnumerable<PointTask> Gets(PointTaskStatus? pointTaskStatus = null);

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="UserId">用户Id</param>
        /// <returns></returns>
        PointTaskUserInfo GetUserInfo(long UserId);
    }
}