﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System.Collections.Generic;
using Tunynet.Repositories;
using System.Linq;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户领取积分任务记录 数据库仓储
    /// </summary>
    public class PointTaskRecordRepository : Repository<PointTaskRecord>, IPointTaskRecordRepository
    {
        /// <summary>
        /// 获取积分任务领取记录列表
        /// </summary>
        /// <param name="taskRecordStatus">领取状态</param>
        /// <param name="taskId">任务Id</param>
        /// <param name="userId">用户Id</param>
        /// <param name="pageSize">页面大小</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        public PagingDataSet<PointTaskRecord> GetRecords(TaskRecordStatus? taskRecordStatus = null, long taskId = 0, List<string> userId = null, int pageSize = 20, int pageIndex = 1)
        {
            Sql sql = Sql.Builder;
            if (taskRecordStatus.HasValue)
                sql.Where("Status=@0", taskRecordStatus);
            if (taskId > 0)
                sql.Where("TaskId=@0", taskId);
            if (userId != null && userId.Count > 0)
                sql.Where("UserId in (@userId)", new { @userId = userId });
            sql.OrderBy("DateCreated desc");
            return GetPagingEntities(pageSize, pageIndex, sql);
        }

        /// <summary>
        /// 根据任务ID删除任务领取记录
        /// </summary>
        /// <param name="taskId"></param>
        public void DeleteTasktoUserByTaskId(long taskId)
        {
            var sql = Sql.Builder;
            sql.Append("Delete from tn_PointTaskRecords");
            if (taskId > 0)
            {
                sql.Where("TaskId=@0", taskId);
                CreateDAO().Execute(sql);
            }
        }

        /// <summary>
        /// 获取积分任务领取记录列表
        /// </summary>
        /// <param name="taskRecordStatus">领取状态</param>
        /// <param name="taskId">任务Id</param>
        /// <param name="userId">用户Id</param>
        /// <returns></returns>
        public PointTaskRecord GetRecordsBy(TaskRecordStatus? taskRecordStatus = null, long taskId = 0, long userId = 0)
        {
            Sql sql = Sql.Builder;
            if (taskRecordStatus.HasValue)
                sql.Where("Status=@0", taskRecordStatus);
            if (taskId > 0)
                sql.Where("TaskId=@0", taskId);
            if (userId > 0)
                sql.Where("UserId=@0", userId);
            sql.OrderBy("DateCreated desc");
            return CreateDAO().Fetch<PointTaskRecord>(sql).FirstOrDefault();
        }
    }
}