﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using System.Collections.Generic;
using System.Linq;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分任务数据库仓储
    /// </summary>
    public class PointTaskRepository : Repository<PointTask>, IPointTaskRepository
    {
        /// <summary>
        /// 获取积分任务列表
        /// </summary>
        /// <param name="pointTaskStatus">积分任务状态</param>
        /// <returns></returns>
        public IEnumerable<PointTask> Gets(PointTaskStatus? pointTaskStatus = null)
        {
            Sql sql = Sql.Builder;
            sql.Select("tn_PointTasks.*").From("tn_PointTasks");
            if (pointTaskStatus.HasValue)
            {
                if (pointTaskStatus == PointTaskStatus.Expired)
                {
                    sql.LeftJoin("tn_PointTaskTypes").On("tn_PointTasks.TypeId = tn_PointTaskTypes.TypeId");
                    sql.Where("tn_PointTaskTypes.IsSetDeadline = @0", true);
                    sql.Where("tn_PointTasks.Deadline<@0", DateTime.Now);
                }
                else
                    sql.Where("tn_PointTasks.Status=@0", pointTaskStatus);
            }
            return CreateDAO().Fetch<PointTask>(sql);
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="userId">用户Id</param>
        /// <returns></returns>
        public PointTaskUserInfo GetUserInfo(long userId)
        {
            Sql sql = Sql.Builder;
            sql.Select("*").From("spb_UserProfiles");
            sql.Where("UserId=@0", userId);
            return CreateDAO().Fetch<PointTaskUserInfo>(sql).FirstOrDefault();
        }
    }
}