﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分任务种类 数据库仓储
    /// </summary>
    public class PointTaskTypeRepository : Repository<PointTaskType>, IPointTaskTypeRepository
    {
        /// <summary>
        /// 获取全部积分任务种类
        /// </summary>
        /// <returns></returns>
        public IEnumerable<PointTaskType> GetTypes(bool? canAddTask = null)
        {
            Sql sql = Sql.Builder;
            sql.Select("*").From("tn_PointTaskTypes");
            if (canAddTask.HasValue)
                sql.Where("CanAddTask=@0", canAddTask);
            return CreateDAO().Fetch<PointTaskType>(sql);
        }
    }
}