﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;

namespace Tunynet.Common
{
    /// <summary>
    /// 业务逻辑实现接口
    /// </summary>
    public interface ISearchWordService
    {
        /// <summary>
        /// 获取搜索词分页集合
        /// </summary>
        /// <param name="word">搜索词</param>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">当前页码</param>
        /// <returns></returns>
        PagingDataSet<SearchWord> GetsForWord(string word, string searchTypeCode, int pageSize = 20, int pageIndex = 1);

        /// <summary>
        /// 增加实体
        /// </summary>
        /// <param name="entity">实体数据</param>
        /// <param name="changeCount">变化计数</param>
        void Set(SearchWord entity, int changeCount = 1);

        /// <summary>
        /// 根据Id查询搜索词
        /// </summary>
        /// <param name="id">搜索词Id</param>
        /// <returns></returns>
        SearchWord Gets(long id);

        /// <summary>
        /// 根据Id删除实体
        /// </summary>
        /// <param name="id">搜索词id</param>
        void Delete(long id);

        /// <summary>
        /// 更新实体
        /// </summary>
        /// <param name="entity">实体数据</param>
        /// <param name="changeCount">变化计数</param>
        void Update(SearchWord entity, int changeCount = 1);

        /// <summary>
        /// 获取前六条数据
        /// </summary>
        /// <param name="searchTypeCode">热词类型</param>
        /// <returns></returns>
        IEnumerable<SearchWord> GetTopWord(string searchTypeCode);
    }
}