﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 热词访问数据库接口
    /// </summary>
    public interface ISearchWordRepository : IRepository<SearchWord>
    {
        /// <summary>
        /// 获取搜索词六条
        /// </summary>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <returns></returns>
        IEnumerable<SearchWord> GetTopWord(string searchTypeCode);

        /// <summary>
        /// 获取搜索词分页集合
        /// </summary>
        /// <param name="word">搜索词</param>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">当前页码</param>
        /// <returns></returns>
        PagingDataSet<SearchWord> GetsForWord(string word, string searchTypeCode, int pageSize = 20, int pageIndex = 1);

        /// <summary>
        /// 判断搜索词是否存在
        /// </summary>
        /// <param name="word">搜索词</param>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <returns></returns>
        SearchWord GetSearchWord(string word, string searchTypeCode);
    }
}