﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 热词访问
    /// </summary>
    public class SearchWordRepository : Repository<SearchWord>, ISearchWordRepository
    {
        /// <summary>
        /// 获取搜索词六条
        /// </summary>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <returns></returns>
        public IEnumerable<SearchWord> GetTopWord(string searchTypeCode)
        {
            string countType = CountTypes.Instance().SearchWordCounts()+"-180";
            Sql sql = Sql.Builder;
            sql.Append("SELECT * FROM tn_SearchWords LEFT JOIN tn_Counts ON tn_SearchWords.Id = tn_Counts.ObjectId");
            sql.Where("CountType=@0", countType);
            if (!string.IsNullOrEmpty(searchTypeCode))
                sql.Where("SearchTypeCode =@0", searchTypeCode);
            sql.OrderBy("StatisticsCount DESC");
            return GetTopEntities(6, sql);
        }

        /// <summary>
        /// 获取搜索词分页集合
        /// </summary>
        /// <param name="word">搜索词</param>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">当前页码</param>
        /// <returns></returns>
        public PagingDataSet<SearchWord> GetsForWord(string word, string searchTypeCode, int pageSize = 20, int pageIndex = 1)
        {
            string countType = CountTypes.Instance().SearchWordCounts()+"-180";
            Sql sql = Sql.Builder;
            sql.Append("SELECT * FROM tn_SearchWords LEFT JOIN tn_Counts ON tn_SearchWords.Id = tn_Counts.ObjectId");
            sql.Where("CountType=@0", countType);
            if (!string.IsNullOrEmpty(word))
                sql.Where("Word like @0", "%" + word + "%");
            if (!string.IsNullOrEmpty(searchTypeCode))
                sql.Where("SearchTypeCode =@0", searchTypeCode);

            sql.OrderBy("StatisticsCount DESC");
            return GetPagingEntities(pageSize, pageIndex, sql);
        }

        /// <summary>
        /// 根据关键词获取实体
        /// </summary>
        /// <param name="Word">搜索词</param>
        /// <param name="searchTypeCode">搜索类型</param>
        /// <returns></returns>
        public SearchWord GetSearchWord(string Word, string searchTypeCode)
        {
            Sql sql = Sql.Builder;
            sql.Append("select * from tn_SearchWords where Word=@0 and SearchTypeCode=@1", Word, searchTypeCode);
            SearchWord searchWord = CreateDAO().FirstOrDefault<SearchWord>(sql);
            return searchWord;
        }
    }
}