﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 搜索热词实体
    /// </summary>
    [TableName("tn_SearchWords")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class SearchWord : IEntity
    {
        #region 构造器

        /// <summary>
        /// 新建实体时使用
        /// </summary>
        /// <returns>用户举报实体</returns>
        public static SearchWord New()
        {
            SearchWord searchWord = new SearchWord()
            {
                Word = string.Empty,
                SearchTypeCode = string.Empty,
                IsAddedByAdministrator = 0,
                DateCreated = DateTime.Now,

                LastModified = DateTime.Now
            };
            return searchWord;
        }

        #endregion 构造器

        #region 需持久化元素

        /// <summary>
        ///搜索词Id
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        /// 搜索词
        /// </summary>
        public string Word { get; set; }

        /// <summary>
        /// 搜索词类型
        /// </summary>
        public string SearchTypeCode { get; set; }

        /// <summary>
        /// 是否由管理员添加
        /// </summary>
        public int IsAddedByAdministrator { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime DateCreated { get; set; }

        /// <summary>
        /// 最后使用时间
        /// </summary>
        public DateTime LastModified { get; set; }

        /// <summary>
        /// 累计搜索次数
        /// </summary>
        [Ignore]
        public int SearchWordCounts
        {
            get { return new CountService(TenantTypeIds.Instance().SearchWord()).Get(CountTypes.Instance().SearchWordCounts(), Id); }
        }

        /// <summary>
        /// 6个月累计搜索次数
        /// </summary>
        [Ignore]
        public int SixSearchWordCounts
        {
            get { return new CountService(TenantTypeIds.Instance().SearchWord()).GetStageCount(CountTypes.Instance().SearchWordCounts(), 180, Id); }
        }

        #endregion 需持久化元素

        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}