﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

namespace Tunynet.Common
{
    /// <summary>
    /// 推荐相关Url获取器
    /// </summary>
    public interface ISpecialContentItemUrlGetter
    {
        /// <summary>
        /// 租户类型Id
        /// </summary>
        string TenantTypeId { get; }

        /// <summary>
        /// 获取特殊对象详细显示url
        /// </summary>
        /// <remarks>如果无特殊对象详细显示页面</remarks>
        /// <param name="specialContentItemObjectId">特殊内容项Id</param>
        /// <param name="tenantTypeId">租户Id</param>
        ///
        /// <returns></returns>
        string GetSpecialContentItemDetailUrl(long specialContentItemObjectId, string tenantTypeId = null);
    }
}