﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 特殊内容项类型仓储
    /// </summary>
    public class SpecialContentTypeRepository : Repository<SpecialContentType>, ISpecialContentTypeRepository
    {
        /// <summary>
        /// 从数据库删除实体(by EntityId)
        /// </summary>
        /// <param name="entityId">主键</param>
        /// <returns>影响的记录数</returns>
        public override int DeleteByEntityId(object entityId)
        {
            Sql sql = Sql.Builder.Append("DELETE FROM tn_SpecialContentItems WHERE tn_SpecialContentItems.TypeId = @0", entityId);
            CreateDAO().Execute(sql);
            int impact = base.DeleteByEntityId(entityId);
            return impact;
        }

        /// <summary>
        /// 从数据库根据租户类型获取推荐类型
        /// </summary>
        /// <param name="tenantTypeId">租户类型Id</param>
        /// <returns></returns>
        public IEnumerable<SpecialContentType> GetTypesByTenantType(string tenantTypeId)
        {
            Sql sql = Sql.Builder;
            sql.Where("TenantTypeId = @0", tenantTypeId);
            return CreateDAO().Fetch<SpecialContentType>(sql);
        }
    }
}