﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户签到明细仓储接口
    /// </summary>
    public interface IUserSignInDetailRepository : IRepository<UserSignInDetail>
    {
        /// <summary>
        /// 获取今天签到总人数
        /// </summary>
        /// <returns></returns>
        int GetSignInTodayCount();

        /// <summary>
        /// 获取用户签到历史明细 recentMonths不填为当前月
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="recentMonths">历史前几个月的</param>
        /// <param name="isMobile">是否手机端</param>
        /// <returns></returns>
        IEnumerable<UserSignInDetail> GetUserHistorDetails(long userId, int recentMonths, bool isMobile);

        /// <summary>
        /// 获取用户今天是否签到
        /// </summary>
        /// <returns></returns>
        bool IsSignIn(long userId);

        /// <summary>
        /// 获取用户某天的签到时间
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="taskTime">任务时间</param>
        /// <returns></returns>
        DateTime GetSignInTime(long userId,DateTime taskTime);

    }
}