﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户签到数据库仓储接口
    /// </summary>
    public interface IUserSignInRepository : IRepository<UserSignIn>
    {
        /// <summary>
        /// 根据用户ID查询用户的签到统计
        /// </summary>
        /// <param name="userId">用户id</param>
        /// <returns>用户签到统计实体</returns>
        UserSignIn GetByUserId(long userId);

        /// <summary>
        /// 获取用户签到数据
        /// </summary>
        /// <param name="keyword">关键字（支持昵称，姓名，手机号，邮箱）</param>
        /// <param name="userSignInOrder">排序：总累计签到、月累计</param>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">数量</param>
        /// <returns></returns>
        PagingDataSet<UserSignIn> Gets(string keyword, UserSignInOrder userSignInOrder, int pageIndex, int pageSize);

        /// <summary>
        /// 删除用户时候删除签到记录
        /// </summary>
        void DeleteTrashDatas();
    }
}