﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户签到明细
    /// </summary>
    public class UserSignInDetailRepository : Repository<UserSignInDetail>, IUserSignInDetailRepository
    {
        /// <summary>
        /// 获取今天签到总人数
        /// </summary>
        /// <returns></returns>
        public int GetSignInTodayCount()
        {
            var sql = Sql.Builder;
            sql.Select("count(tn_UserSignInDetails.Id)").From("tn_UserSignInDetails").Where("DateCreated >=@0", DateTime.Today);
            return CreateDAO().SingleOrDefault<int>(sql);
        }

        /// <summary>
        /// 获取用户签到历史明细 recentMonths不填为当前月
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="recentMonths">历史前几个月的</param>
        /// <param name="isMobile">是否手机端</param>
        /// <returns></returns>
        public IEnumerable<UserSignInDetail> GetUserHistorDetails(long userId, int recentMonths, bool isMobile)
        {
            var sql = Sql.Builder;
            if (isMobile)
            {
                sql.Select("*").From("tn_UserSignInDetails").Where("UserId=@0 and DateCreated>=@1 and DateCreated< @2", userId, new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1), DateTime.Now);
            }
            else
            {
                var historyDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                if (recentMonths > 0)
                    historyDate = historyDate.AddMonths(-recentMonths);
                sql.Select("*").From("tn_UserSignInDetails").Where("UserId=@0 and DateCreated>=@1 and DateCreated< @2", userId, historyDate, historyDate.AddMonths(1));
            }
            return CreateDAO().Fetch<UserSignInDetail>(sql);
        }

        /// <summary>
        /// 获取用户今天是否签到
        /// </summary>
        /// <returns></returns>
        public bool IsSignIn(long userId)
        {
            var sql = Sql.Builder;
            sql.Select("tn_UserSignInDetails.Id").From("tn_UserSignInDetails").Where("tn_UserSignInDetails.UserId=@0 and tn_UserSignInDetails.DateCreated>=@1 and tn_UserSignInDetails.DateCreated<@2", userId, DateTime.Today, DateTime.Today.AddDays(1));
            long result = CreateDAO().SingleOrDefault<long>(sql);
            return result > 0 ? true : false;
        }

        /// <summary>
        /// 获取用户某天的签到时间
        /// </summary>
        /// <param name="userId">用户Id</param>
        /// <param name="taskTime">任务时间</param>
        /// <returns></returns>
        public DateTime GetSignInTime(long userId, DateTime taskTime)
        {
            var sql = Sql.Builder;
            sql.Select("tn_UserSignInDetails.DateCreated").From("tn_UserSignInDetails").Where("tn_UserSignInDetails.UserId=@0 and tn_UserSignInDetails.DateCreated>=@1 and tn_UserSignInDetails.DateCreated<@2", userId, taskTime.Date, taskTime.Date.AddDays(1));
            DateTime SignInTime = CreateDAO().Fetch<DateTime>(sql).Count > 0 ? CreateDAO().SingleOrDefault<DateTime>(sql) : DateTime.Now.AddDays(1);
            return SignInTime;
        }
    }
}