﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户签到数据库仓储
    /// </summary>
    public class UserSignInRepository : Repository<UserSignIn>, IUserSignInRepository
    {
        /// <summary>
        /// 根据用户ID查询用户的签到统计
        /// </summary>
        /// <param name="userId">用户id</param>
        /// <returns>用户签到统计实体</returns>
        public UserSignIn GetByUserId(long userId)
        {
            var sql = Sql.Builder;
            sql.Where("UserId=@0", userId);
            return CreateDAO().SingleOrDefault<UserSignIn>(sql);
        }

        /// <summary>
        /// 获取用户签到数据
        /// </summary>
        /// <param name="keyword">关键字（支持昵称，姓名，手机号，邮箱）</param>
        /// <param name="userSignInOrder">排序：总累计签到、月累计</param>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">数量</param>
        /// <returns></returns>
        public PagingDataSet<UserSignIn> Gets(string keyword, UserSignInOrder userSignInOrder, int pageIndex, int pageSize)
        {
            var sql = Sql.Builder;
            sql.Select("tn_UserSignIns.*").From("tn_UserSignIns");
            if (!string.IsNullOrEmpty(keyword))
                sql.InnerJoin("tn_Users").On("tn_Users.UserId=tn_UserSignIns.UserId").Where("tn_Users.UserName like @0 or  tn_Users.TrueName like @0 or tn_Users.AccountMobile like @0 or tn_Users.AccountEmail like @0 ", "%" + keyword + "%");
            switch (userSignInOrder)
            {
                case UserSignInOrder.SignCount_Desc:
                    sql.OrderBy("SignCount desc");
                    break;

                case UserSignInOrder.MonthSignCount_Desc:
                    sql.OrderBy("MonthSignCount desc");
                    break;
            }
            return GetPagingEntities(pageSize, pageIndex, sql);
        }

        /// <summary>
        /// 更新每日连签,月累计签
        /// </summary>
        public void UpdateUserSignInTask()
        {
            List<Sql> sqls = new List<Sql>();
            sqls.Add(Sql.Builder.Append("update tn_UserSignIns set ContinuedSignCount = 0 where LastSignedIn <@0 ", DateTime.Today.AddDays(-1)));
            if (DateTime.Today.Day == 1)
                sqls.Add(Sql.Builder.Append("update tn_UserSignIns set MonthSignCount = 0 "));
            CreateDAO().Execute(sqls);
        }

        /// <summary>
        /// 删除用户时候删除签到记录
        /// </summary>
        public void DeleteTrashDatas()
        {
            List<Sql> sqls = new List<Sql>();
            Sql sql = Sql.Builder.Append("delete  from tn_UserSignIns where not exists (select 1 from tn_Users where  tn_UserSignIns.UserId = tn_Users.UserId AND tn_Users.Status>-1) ");
            Sql sql1 = Sql.Builder.Append("delete from tn_UserSignInDetails where not exists (select 1 from tn_Users where  tn_UserSignInDetails.UserId = tn_Users.UserId AND tn_Users.Status>-1)");
            sqls.Add(sql);
            sqls.Add(sql1);
            CreateDAO().Execute(sqls);
        }
    }
}