﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Newtonsoft.Json;
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户签到统计
    /// </summary>
    [TableName("tn_UserSignIns")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class UserSignIn : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static UserSignIn New()
        {
            UserSignIn userSignIn = new UserSignIn
            {
                TradePointSum = 0,
                ExperiencePointSum = 0,
                ContinuedSignCount = 0,
                MonthSignCount = 0,
                SignCount = 0,
                LastSignedIn = DateTime.Now
            };
            return userSignIn;
        }

        /// <summary>
        /// 自增长
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        ///用户ID
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        /// 累计奖励金币
        /// </summary>
        public int TradePointSum { get; set; }

        /// <summary>
        /// 累计奖励积分
        /// </summary>
        public int ExperiencePointSum { get; set; }

        /// <summary>
        /// 连续签到次数
        /// </summary>
        public int ContinuedSignCount { get; set; }

        /// <summary>
        /// 月累计签到次数
        /// </summary>
        public int MonthSignCount { get; set; }

        /// <summary>
        /// 累计签到次数
        /// </summary>
        public int SignCount { get; set; }

        /// <summary>
        /// 最后签到时间
        /// </summary>
        public DateTime LastSignedIn { get; set; }

        /// <summary>
        /// 当日是否签到
        /// </summary>
        /// <returns></returns>
        [Ignore]
        public bool IsSign
        {
            get
            {
                return new UserSignInDetailRepository().IsSignIn(this.UserId);
            }
        }

        /// <summary>
        /// 用户属性
        /// </summary>
        [Ignore]
        [JsonIgnore]
        public User User { get { return new UserRepository().GetUser(this.UserId); } }

        //public UserSignInDetail UserSignInDetail { get { return new UserSignInDetailRepository.GetUserHistorDetails(this.UserId)} }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}