﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户签到明细
    /// </summary>
    [TableName("tn_UserSignInDetails")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class UserSignInDetail : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static UserSignInDetail New(long userId)
        {
            UserSignInDetail userSignInDetail = new UserSignInDetail
            {
                UserId = userId,
                TradePoints = 0,
                ExperiencePoints = 0,
                DateCreated = DateTime.Now
            };
            return userSignInDetail;
        }

        /// <summary>
        /// 自增长
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        ///用户ID
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        /// 签到奖励金币
        /// </summary>
        public int TradePoints { get; set; }

        /// <summary>
        /// 签到奖励积分
        /// </summary>
        public int ExperiencePoints { get; set; }

        /// <summary>
        /// 签到时间
        /// </summary>
        public DateTime DateCreated { get; set; }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}