﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Tunynet.Events;

namespace Tunynet.Common
{
    /// <summary>
    /// 重新统计计数事件
    /// </summary>
    public class CountEventModule : IEventMoudle
    {
        /// <summary>
        /// 注册事件
        /// </summary>
        public void RegisterEventHandler()
        {
            EventBus<CountEntity>.Instance().After += CountEventModule_After;
        }

        /// <summary>
        /// 重新统计计数事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="eventArgs"></param>
        private void CountEventModule_After(CountEntity sender, CommonEventArgs eventArgs)
        {
            CountService countService = new CountService("");
            countService.ResetStatisticsCount();
        }
    }
}