﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using Tunynet.CMS;
using Tunynet.Events;
using Tunynet.Logging;
using Tunynet.Post;

namespace Tunynet.Common
{
    /// <summary>
    /// 删除用户时事件
    /// </summary>
    public class DeleteUserEventModule : IEventMoudle
    {
        private OperationLogService operationLogService;
        private RoleService roleService;
        private MessageService messageService;
        private IKvStore kvStore;
        private TenantTypeService tenantTypeService;
        private ContentModelService contentModelService;
        private CategoryService categoryService;
        private CommentService commentService;
        private NoticeService noticeService;
        private FollowService followService;
        private AccountBindingService accountBindingService;
        private UserService userService;
        private ThreadService threadService;
        private ContentItemService contentItemService;
        private SectionService sectionService;
        /// <summary>
        /// 构造函数
        /// </summary>
        public DeleteUserEventModule(OperationLogService operationLogService,
            RoleService roleService, MessageService messageService,
            IKvStore kvStore,
            TenantTypeService tenantTypeService,
            ContentModelService contentModelService,
            CategoryService categoryService,
            CommentService commentService,
            NoticeService noticeService,
            FollowService followService,
            AccountBindingService accountBindingService,
            ThreadService threadService,
            UserService userService,
            ContentItemService contentItemService,
           SectionService sectionService)
        {
            this.operationLogService = operationLogService;
            this.roleService = roleService;
            this.messageService = messageService;
            this.kvStore = kvStore;
            this.tenantTypeService = tenantTypeService;
            this.contentModelService = contentModelService;
            this.categoryService = categoryService;
            this.commentService = commentService;
            this.noticeService = noticeService;
            this.followService = followService;
            this.accountBindingService = accountBindingService;
            this.userService = userService;
            this.threadService = threadService;
            this.contentItemService = contentItemService;
            this.sectionService = sectionService;
        }

        /// <summary>
        /// 注册事件处理方法
        /// </summary>
        public void RegisterEventHandler()
        {
            EventBus<User, DeleteUserEventArgs>.Instance().After += new CommonEventHandler<User, DeleteUserEventArgs>(DeleteUserEventMoudle_After);
        }

        /// <summary>
        /// 删除用户事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="eventArgs"></param>
        private void DeleteUserEventMoudle_After(User sender, DeleteUserEventArgs eventArgs)
        {
            //删除用户贴子
            foreach (var item in threadService.GetUserThreads(TenantTypeIds.Instance().Thread(), sender.UserId, true, 9999))
            {
                threadService.Delete(item.ThreadId);
            }
            //删除用户创建的贴吧
            foreach (var item in sectionService.GetsByUserId(TenantTypeIds.Instance().Bar(), sender.UserId))
            {
                sectionService.Delete(item.SectionId);
            }
            //清除用户资讯
            contentItemService.DeleteContentItemOfUser(sender.UserId);

            //清除用户关于分类的数据
            categoryService.CleanByUser(sender.UserId);

            //清除用户评论
            foreach (var item in commentService.GetUserComments(sender.UserId, null, null, null, 9999, 1))
            {
                commentService.Delete(item.Id);
            }

            //清除用户的私信
            messageService.ClearSessionsFromUser(sender.UserId);

            //清除通知的用户数据
            noticeService.CleanByUser(sender.UserId);

            //清除用户关于关注用户的数据
            followService.CleanByUser(sender.UserId);
            //清除帐号绑定数据
            var accountBindings = accountBindingService.GetAccountBindings(sender.UserId);
            foreach (var accountBinding in accountBindings)
            {
                accountBindingService.DeleteAccountBinding(accountBinding.UserId, accountBinding.AccountTypeKey);
            }
        }
    }
}