﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Tunynet.Events;
using Tunynet.Logging;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章创建和删除的事件
    /// </summary>
    public class MessageEventModule : IEventMoudle
    {
        private UserService userService;
        private MessageService messageService;
        //构造
        public MessageEventModule(UserService userService, MessageService messageService)
        {
            this.userService = userService;
            this.messageService = messageService;
        }

        /// <summary>
        /// 注册事件处理程序
        /// </summary>
        public void RegisterEventHandler()
        {
            //用户修改对外显示名称事件
            EventBus<User>.Instance().AfterWithHistory += new EventHandlerWithHistory<User, CommonEventArgs>(UserEventModule_AfterWithHistory);
        }

        /// <summary>
        /// 用户修改对外显示名称事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="eventArgs"></param>
        /// <param name="historyData"></param>
        private void UserEventModule_AfterWithHistory(User sender, CommonEventArgs eventArgs, User historyData)
        {
            if (historyData != null && eventArgs.EventOperationType == EventOperationType.Instance().Update())
            {
                if (userService.CanEditDisplayName(sender, historyData))
                {
                    messageService.UpdateMessageAuthor(sender.UserId, sender.DisplayName);
                }
            }
        }
    }
}