﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace Tunynet.Common
{
    /// <summary>
    /// 编辑贴子的EditModel
    /// </summary>
    public class ThreadEditModel
    {
        /// <summary>
        /// 贴子Id
        /// </summary>
        public long ThreadId { get; set; }

        /// <summary>
        /// 贴子标题
        /// </summary>
        [WaterMark(Content = "标题")]
        [Required(ErrorMessage = "请输入标题")]
        [StringLength(64, ErrorMessage = "不能超过64个字符")]
        [DataType(DataType.Text)]
        public string Subject { get; set; }

        /// <summary>
        /// 贴子的内容
        /// </summary>
        [Required(ErrorMessage = "请输入内容")]
        [AllowHtml]
        [DataType(DataType.Html)]
        public string Body { get; set; }

        /// <summary>
        /// 所属贴吧Id
        /// </summary>
        public long SectionId { get; set; }

        /// <summary>
        /// 贴子分类
        /// </summary>
        public long CategoryId { get; set; }

        /// <summary>
        /// AssociateId(创建的时候是随机生成的)
        /// </summary>
        public long AssociateId { get; set; }

        #region 提交表单扩展

        /// <summary>
        /// 编辑器附件id集合 用，拼接 包含图片和文件 
        /// </summary>
        public string AttachmentIds { get; set; }

        /// <summary>
        /// Body Imgids
        /// </summary>
        public IEnumerable<long> AttachmentIdsFinal
        {
            get
            {
                if (string.IsNullOrEmpty(AttachmentIds))
                {
                    return new List<long>();
                }
                var attachmentIds = new List<string>(AttachmentIds.Split(','));
                var attachmentIdsFinal = attachmentIds.Where(n => n.Length > 0);
                if (attachmentIdsFinal.Count() > 0)
                {
                    return attachmentIdsFinal.Select(n => Convert.ToInt64(n)).ToList();
                }
                return new List<long>();
            }
        }

        #endregion 提交表单扩展
    }
}