﻿//<tunynetcopyright>
//--------------------------------------------------------------
//<version>v0.5</verion>
//<createdate>2017-2-10</createdate>
//<author>zhangzh</author>
//<email>zhangzh@tunynet.com</email>
//<log date="2017-2-10" version="0.5">新建</log>
//--------------------------------------------------------------
//</tunynetcopyright>

using Tunynet.Email;
using Tunynet.Repositories;

namespace Tunynet.Spacebuilder
{
    /// <summary>
    /// 生成EmailSettings
    /// </summary>
    public class EmailSettingsManager : IEmailSettingsManager
    {
        private ISettingsRepository<EmailSettings> repository;

        /// <summary>
        /// 构造器
        /// </summary>
        public EmailSettingsManager()
        {
            repository = new SettingsRepository<EmailSettings>();
        }

        #region IEmailSettingsManager 成员

        /// <summary>
        /// 获取EmailSettings
        /// </summary>
        /// <returns></returns>
        EmailSettings IEmailSettingsManager.Get()
        {
            return repository.Get();
        }

        /// <summary>
        /// 保存EmailSettings
        /// </summary>
        /// <param name="emailSettings"></param>
        public void Save(EmailSettings emailSettings)
        {
            repository.Save(emailSettings);
        }

        #endregion IEmailSettingsManager 成员
    }
}