﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System;
using Tunynet.Common.Configuration;
using Tunynet.Events;
using Tunynet.Logging;
using Tunynet.Settings;
using Tunynet.Spacebuilder;
using Tunynet.Utilities;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户管理事件
    /// </summary>
    public partial class MembershipEventModule : IEventMoudle
    {
        private UserService userService;

        private IKvStore kvStore;
        /// <summary>
        /// 构造函数
        /// </summary>
        public MembershipEventModule(UserService userService, IKvStore kvStore)
        {
            this.userService = userService;
            this.kvStore = kvStore;
        }

        /// <summary>
        /// 注册事件处理程序
        /// </summary>
        public void RegisterEventHandler()
        {
            EventBus<User>.Instance().AfterWithHistory += new EventHandlerWithHistory<User, CommonEventArgs>(UserEventModule_AfterWithHistory);
        }

        /// <summary>
        /// 用户编辑事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="eventArgs"></param>
        /// <param name="historyData"></param>
        /// <remarks>
        /// 如果更改了站点设置的对外显示名称 记录最后变更时间
        /// </remarks>
        private void UserEventModule_AfterWithHistory(User sender, CommonEventArgs eventArgs, User historyData)
        {
            if (historyData != null && eventArgs.EventOperationType == EventOperationType.Instance().Update())
            {
                if (userService.CanEditDisplayName(sender, historyData))
                {
                    kvStore.Set(KvKeys.Instance().UserDisplayNameLastModified(sender.UserId), DateTime.Now.Date);
                }
            }
        }
    }
}