﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Web.Mvc;
using Tunynet.Common;

namespace Tunynet.Spacebuilder
{
    /// <summary>
    /// 租户管理控制器
    /// </summary>
    [ConsoleAuthorize]
    public partial class ControlPanelController : Controller
    {

        private ManageTenantTypesService manageTenantTypesService = DIContainer.Resolve<ManageTenantTypesService>();

        /// <summary>
        /// 租户管理
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public ActionResult ManageTenantTypes()
        {
            if (!IsSiteManager())
            {
                return RedirectToAction("BankEndError");
            }

            var tenantTypesInDatabase = manageTenantTypesService.Gets();
            var tenantTypesInCode = manageTenantTypesService.GetTenantTypesInCode();

            var servicesInCode = manageTenantTypesService.GetServicesInCode();

            var tenantTypesSelectList = new List<SelectListItem>();
            var servicesSelectList = new List<SelectListItem>();

            if (tenantTypesInDatabase != null && tenantTypesInDatabase.Any() && tenantTypesInCode != null && tenantTypesInCode.Any())
            {
                foreach (var item in tenantTypesInDatabase.Select(n => n.TenantTypeId).Union(tenantTypesInCode.Select(n => n.Key)).Distinct())
                {
                    var itemInDB = tenantTypesInDatabase.Where(n => n.TenantTypeId == item).FirstOrDefault();
                    var itemInCode = tenantTypesInCode.Where(n => n.Key == item).FirstOrDefault();
                    if (itemInDB != null)
                    {
                        tenantTypesSelectList.Add(new SelectListItem() { Text = itemInDB.Name, Value = itemInDB.TenantTypeId });
                    }
                    else
                    {
                        tenantTypesSelectList.Add(new SelectListItem() { Text = itemInCode.Value, Value = itemInCode.Key });
                    }
                }
            }
            foreach (var item in servicesInCode)
            {
                servicesSelectList.Add(new SelectListItem() { Text = item.Value, Value = item.Key });
            }


            ViewData["tenantTypesSelectList"] = tenantTypesSelectList;
            ViewData["servicesSelectList"] = servicesSelectList;

            return View();
        }

        /// <summary>
        /// 租户管理列表
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <param name="serviceKey"></param>
        /// <returns></returns>
        public PartialViewResult _ListTenantTypes(string tenantTypeId = "", string serviceKey = "")
        {
            var tenantTypesInDatabase = manageTenantTypesService.GetTenantTypesInDatabase(tenantTypeId, serviceKey);
            var tenantTypesInCode = manageTenantTypesService.GetTenantTypesInCode();

            var tenantTypes = new List<TenantTypeEditModel>();
            IEnumerable<string> finalTenantTypeIds = null;

            if (!string.IsNullOrEmpty(tenantTypeId))
            {
                finalTenantTypeIds = tenantTypesInDatabase.Select(n => n.TenantTypeId).Intersect((new List<string>() { tenantTypeId }));
            }
            else
            {
                if (!string.IsNullOrEmpty(serviceKey))
                {
                    finalTenantTypeIds = tenantTypesInDatabase.Select(n => n.TenantTypeId).Distinct();
                }
                else
                {
                    finalTenantTypeIds = tenantTypesInDatabase.Select(n => n.TenantTypeId).Union(tenantTypesInCode.Select(n => n.Key)).Distinct();
                }
            }


            foreach (var item in finalTenantTypeIds)
            {
                var itemsInDatabase = tenantTypesInDatabase.Where(n => n.TenantTypeId == item);

                var itemInCode = tenantTypesInCode.Where(n => n.Key == item).FirstOrDefault();
                var isInCode = itemInCode.Key != null;

                var tenantTypeEditModel = new TenantTypeEditModel();
                if (itemsInDatabase != null && itemsInDatabase.Any())
                {
                    var itemInDatabase = itemsInDatabase.First();

                    tenantTypeEditModel.TenantTypeId = itemInDatabase.TenantTypeId;
                    tenantTypeEditModel.Name = itemInDatabase.Name;
                    tenantTypeEditModel.ClassType = itemInDatabase.ClassType;
                    tenantTypeEditModel.ServiceKeys = itemsInDatabase.Select(n => n.ServiceKey);
                    tenantTypeEditModel.IsInDatabase = true;
                    tenantTypeEditModel.IsInCode = isInCode;
                }
                else
                {
                    tenantTypeEditModel.TenantTypeId = itemInCode.Key;
                    tenantTypeEditModel.Name = itemInCode.Value;
                    tenantTypeEditModel.ClassType = "";
                    tenantTypeEditModel.ServiceKey = "";
                    tenantTypeEditModel.ServiceKeys = null;

                    tenantTypeEditModel.IsInDatabase = false;
                    tenantTypeEditModel.IsInCode = isInCode;
                }

                tenantTypes.Add(tenantTypeEditModel);
            }

            return PartialView(tenantTypes.OrderBy(n => n.TenantTypeId));
        }


        /// <summary>
        /// 编辑租户信息
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <returns></returns>
        [HttpGet]
        public PartialViewResult _EditTenantType(string tenantTypeId)
        {
            if (!string.IsNullOrEmpty(tenantTypeId))
            {
                var tenantTypeInfo = manageTenantTypesService.GetTenantTypeInfo(tenantTypeId);
                var services = manageTenantTypesService.GetServicesInCode();
                var items = new Dictionary<string, string>();
                var selectedValues = new Dictionary<string, string>();
                foreach (var item in services)
                {
                    items.Add(item.Key, item.Key + ", " + item.Value);
                }
                foreach (var item in tenantTypeInfo.ServiceKeys)
                {
                    var value = items.Where(n => n.Key == item).FirstOrDefault().Value;
                    if (value != null)
                    {
                        selectedValues.Add(item, value);
                    }
                }

                if (tenantTypeInfo != null)
                {
                    var servicesMultiSelect = new MultiSelectList(items, "key", "value", selectedValues);
                    ViewData["servicesMultiSelect"] = servicesMultiSelect;
                    return PartialView(tenantTypeInfo);
                }
            }
            return PartialView();
        }

        /// <summary>
        /// 编辑租户信息
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult _EditTenantType(TenantTypeEditModel model)
        {
            var affectLineCout = manageTenantTypesService.Update(model);
            if (affectLineCout > 0)
            {
                return Json(new StatusMessageData(StatusMessageType.Success, "更新租户信息成功，影响行数" + affectLineCout));
            }
            else
            {
                return Json(new StatusMessageData(StatusMessageType.Hint, "更新租户信息失败!"));
            }
        }

        /// <summary>
        /// 删除租户
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <returns></returns>
        public JsonResult DeleteTenantType(string tenantTypeId)
        {
            if (!string.IsNullOrEmpty(tenantTypeId))
            {
                var affectLineCount = manageTenantTypesService.Delete(tenantTypeId);
                return Json(new StatusMessageData(StatusMessageType.Success, "成功删除租户信息，影响行数" + affectLineCount));
            }
            return Json(new StatusMessageData(StatusMessageType.Hint, "删除租户信息失败!"));
        }

        /// <summary>
        /// 根据实体名称生成ClassType
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <returns></returns>
        public JsonResult GetClassType(string className)
        {
            var classType = string.Empty;
            var classNames = new Dictionary<string, string>();
            var interfaseClassType = typeof(IEntity);
            //Assembly a = Assembly.GetAssembly(superClassType);
            Assembly spb = Assembly.Load("Tunynet.Spacebuilder");
            Assembly core = Assembly.Load("Tunynet.Core");
            Assembly modules = Assembly.Load("Tunynet.Modules");
            Assembly presentation = Assembly.Load("Tunynet.Presentation");
            Assembly ask = Assembly.Load("Spacebuilder.Ask");
            Assembly doc = Assembly.Load("Spacebuilder.Doc");
            Assembly events = Assembly.Load("Spacebuilder.Event");
            Assembly pointMall = Assembly.Load("Spacebuilder.PointMall");
            Assembly vote = Assembly.Load("Spacebuilder.Vote");

            var assemblys = new List<Assembly>() { spb, core, modules, presentation, ask, doc, events, pointMall, vote };

            foreach (var a in assemblys)
            {
                foreach (Type t in a.GetTypes())
                {
                    if (t.IsClass)
                    {
                        //判断类是否实现接口
                        if (interfaseClassType.IsAssignableFrom(t))
                        {
                            classNames.Add(t.Name, t.AssemblyQualifiedName);
                        }
                    }
                }
            }
            if (classNames != null && classNames.Any())
            {
                classType = classNames.Where(n => n.Key == className).FirstOrDefault().Value;
            }

            return Json(classType, JsonRequestBehavior.AllowGet);
        }


    }
}
