﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Tunynet.Common;
using Tunynet.Repositories;

namespace Tunynet.Spacebuilder
{
    public interface IManageTenantTypesRepository : IRepository<TenantType>
    {
        /// <summary>
        /// 根据条件获取数据库中的租户和服务
        /// </summary>
        /// <param name="tenantTypeId">租户Id</param>
        /// <param name="serviceKey">服务</param>
        /// <returns></returns>
        IEnumerable<TenantTypeEditModel> Gets(string tenantTypeId = null, string serviceKey = null);

        /// <summary>
        /// 更新租户与服务对应关系
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <param name="finalServiceKeys"></param>
        /// <returns></returns>
        int UpdateTenantTypeInService(string tenantTypeId, IEnumerable<string> finalServiceKeys);

        /// <summary>
        /// 删除租户信息 和与租户的关联
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <returns></returns>
        int DeleteTenantType(string tenantTypeId );

        ///// <summary>
        ///// 根据租户Id获取ServiceKey
        ///// </summary>
        ///// <param name="tenantTypeId"></param>
        ///// <returns></returns>
        //IEnumerable<string> GetServiceKeys(string tenantTypeId);

        ///// <summary>
        ///// 根据租户Id获取数据库中的租户实体
        ///// </summary>
        ///// <param name="tenantTypeId">租户Id</param>
        ///// <returns></returns>
        //IEnumerable<TenantTypeEditModel> GetTenantTypeById(string tenantTypeId);
    }
}
