﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Tunynet.Common;
using Tunynet.Repositories;

namespace Tunynet.Spacebuilder
{
    public class ManageTenantTypesRepository : Repository<TenantType>, IManageTenantTypesRepository
    {
        /// <summary>
        /// 根据条件获取数据库中的租户和服务
        /// </summary>
        /// <param name="tenantTypeId">租户Id</param>
        /// <param name="serviceKey">服务Key</param>
        /// <returns></returns>
        public IEnumerable<TenantTypeEditModel> Gets(string tenantTypeId = null, string serviceKey = null)
        {
            Sql sql = Sql.Builder;
            sql.Select("*").From("tn_TenantTypes T");
            sql.LeftJoin("tn_TenantTypesInServices TS").On("T.TenantTypeId=TS.TenantTypeId");

            if (!string.IsNullOrEmpty(tenantTypeId))
            {
                sql.Where("T.TenantTypeId=@0", tenantTypeId);
            }

            if (!string.IsNullOrEmpty(serviceKey))
            {
                sql.Where("TS.ServiceKey=@0", serviceKey);
            }

            return CreateDAO().Fetch<TenantTypeEditModel>(sql.OrderBy("T.TenantTypeId"));
        }

        /// <summary>
        /// 更新租户与服务对应关系
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <param name="finalServiceKeys"></param>
        /// <returns></returns>
        public int UpdateTenantTypeInService(string tenantTypeId, IEnumerable<string> finalServiceKeys)
        {
            var sql = Sql.Builder.Select("*").From("tn_TenantTypesInServices TS").Where("TS.TenantTypeId=@0", tenantTypeId);

            var oldServicesKeys = CreateDAO().Fetch<TenantTypesInService>(sql)?.Select(n => n.ServiceKey);

            var insertList = finalServiceKeys?.Except(oldServicesKeys ?? new List<string>());
            var deleteList = oldServicesKeys?.Except(finalServiceKeys ?? new List<string>());

            var sqls = new List<Sql>();
            if (insertList != null && insertList.Any())
            {
                foreach (var item in insertList)
                {
                    sqls.Add(Sql.Builder.Append("INSERT INTO tn_TenantTypesInServices(TenantTypeId,ServiceKey) VALUES(@0,@1)", tenantTypeId, item));
                }
            }
            if (deleteList != null && deleteList.Any())
            {
                foreach (var item in deleteList)
                {
                    sqls.Add(Sql.Builder.Append("DELETE FROM tn_TenantTypesInServices WHERE TenantTypeId=@0 AND ServiceKey=@1", tenantTypeId, item));
                }
            }
            return CreateDAO().Execute(sqls);
        }

        /// <summary>
        /// 删除租户信息 和与租户的关联
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <returns></returns>
        public int DeleteTenantType(string tenantTypeId)
        {
            var count = base.DeleteByEntityId(tenantTypeId);
            var sql = Sql.Builder.Append("DELETE FROM tn_TenantTypesInServices WHERE TenantTypeId=@0", tenantTypeId);
            count += CreateDAO().Execute(sql);

            return count;
        }

        ///// <summary>
        ///// 根据租户Id获取Service
        ///// </summary>
        ///// <param name="tenantTypeId">租户Id</param>
        ///// <returns></returns>
        //public IEnumerable<string> GetServiceKeys(string tenantTypeId)
        //{
        //    Sql sql = Sql.Builder;
        //    if (!string.IsNullOrEmpty(tenantTypeId))
        //    {
        //        sql.Select("ServiceKey").From("tn_TenantTypesInServices");
        //        sql.Where("tn_TenantTypesInServices.TenantTypeId=@0", tenantTypeId);
        //    }
        //    return CreateDAO().Fetch<string>(sql);
        //}

        ///// <summary>
        ///// 获取租户Id获取租户实体
        ///// </summary>
        ///// <returns></returns>
        //public IEnumerable<TenantTypeEditModel> GetTenantTypeById(string tenantTypeId)
        //{
        //    Sql sql = Sql.Builder;
        //    sql.Select("*").From("tn_TenantTypes");
        //    sql.InnerJoin("tn_TenantTypesInServices").On("tn_TenantTypes.TenantTypeId=tn_TenantTypesInServices.TenantTypeId");
        //    if (!string.IsNullOrEmpty(tenantTypeId))
        //    {
        //        sql.Where("tn_TenantTypes.TenantTypeId=@0", tenantTypeId);
        //    }
        //    return CreateDAO().Fetch<TenantTypeEditModel>(sql);
        //}
    }
}
