﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tunynet.Spacebuilder
{
    /// <summary>
    /// 租户模板
    /// </summary>
    public class TenantTypeEditModel
    {

        /// <summary>
        /// 租户Id
        /// </summary>
        [Display(Name="租户Id")]
        [Required(ErrorMessage ="租户Id为必填项")]
        public string TenantTypeId { get; set; }

        /// <summary>
        /// 租户名称
        /// </summary>
        [Display(Name="租户名称")]
        [Required(ErrorMessage ="请输入租户名称")]
        public string Name { get; set; }

        /// <summary>
        /// 租户所关联实体的ClassType
        /// </summary>
        [Display(Name="租户ClassType")]
        public string ClassType { get; set; }

        /// <summary>
        /// 服务
        /// </summary>
        public string ServiceKey { get; set; }

        /// <summary>
        /// 服务集合
        /// </summary>
        [Display(Name="关联服务")]
        public IEnumerable<string> ServiceKeys { get; set; }

        /// <summary>
        /// 是否存在于数据库中
        /// </summary>
        public bool IsInDatabase { get; set; }

        /// <summary>
        /// 是否存在于代码中
        /// </summary>
        public bool IsInCode { get; set; }

    }
}
