﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Tunynet.Common;
using Tunynet.Common.Repositories;
using Tunynet.Tasks;

namespace Tunynet.Spacebuilder
{
    /// <summary>
    /// 清理垃圾临时附件任务
    /// </summary>
    public class DeleteTrashDataTask : ITask
    {
        /// <summary>
        /// 任务执行的内容
        /// </summary>
        /// <param name="taskDetail">任务配置状态信息</param>
        public void Execute(TaskDetail taskDetail)
        {
            ////顶踩删除垃圾数据
            //new AttitudeRepository().DeleteTrashDatas();
            //收藏删除垃圾数据
            new FavoriteRepository().DeleteTrashDatas();
            //todo:@fanggm 这里记得更改
            //停止删除附件服务 因为租户Id没有和附件服务关联会导致误删
            //附件删除垃圾数据
            new AttachmentRepository<Attachment>().DeleteTrashDatas();
            ////删除@用户
            new AtUserRepository().DeleteTrashDatas();
            //标签删除垃圾数据
            new TagRepository<Tag>().DeleteTrashDatas();
            //评论删除垃圾数据
            new CommentRepository().DeleteTrashDatas();
            //计数删除垃圾数据
            new CountRepository().DeleteTrashCount();
            //管理员删除垃圾数据
            new CategoryManagerRepository().DeleteTrashDatas();
            //清楚举报的垃圾数据
            new ImpeachReportRepository().DeleteTrashDatas();
            //删除用户签到的垃圾数据
            new UserSignInRepository().DeleteTrashDatas();
        }
    }
}