﻿-- ----------------------------
-- Table structure for tn_impeachreports
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_impeachreports` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `TenantTypeId` char(6) DEFAULT NULL,
  `ReportObjectId` bigint(20) DEFAULT NULL,
  `UserId` bigint(20) DEFAULT NULL,
  `Reporter` varchar(64) DEFAULT NULL,
  `Reason` int(11) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Description` varchar(255) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`Id`),
  KEY `TenantTypeId` (`TenantTypeId`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_medalconditions
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_medalconditions` (
  `ConditionId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '条件Id',
  `ConditionName` varchar(64) NOT NULL COMMENT '条件名',
  `DisplayOrder` bigint(20) NOT NULL COMMENT '勋章条件显示排序',
  `MethodName` varchar(64) NOT NULL COMMENT '验证方法名（接收最小条件值和验证用户id）',
  PRIMARY KEY (`ConditionId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_medalgroups
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_medalgroups` (
  `GroupId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '勋章互斥组表',
  `GroupName` varchar(64) NOT NULL COMMENT '勋章互斥组名',
  `MeadlCount` int(11) NOT NULL COMMENT '勋章数',
  `DateCreated` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`GroupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_medalinconditions
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_medalinconditions` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `MedalId` bigint(20) NOT NULL,
  `ConditionId` bigint(20) NOT NULL,
  `MinCondition` int(11) NOT NULL COMMENT '最小条件',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_medalingroups
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_medalingroups` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `MedalId` bigint(20) NOT NULL,
  `GroupId` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_medals
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_medals` (
  `MedalId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '勋章Id',
  `MedalName` varchar(64) NOT NULL COMMENT '勋章名',
  `AwardStatus` tinyint(4) NOT NULL COMMENT '授予状态（可以授予、停止授予）',
  `AwardType` tinyint(4) NOT NULL COMMENT '授予方式（自主申请、人工授予）',
  `ImageAttachmentId` bigint(20) NOT NULL COMMENT '勋章标题图ID',
  `Description` text NOT NULL COMMENT '描述',
  `DisplayOrder` bigint(20) NOT NULL COMMENT '勋章显示排序',
  `DateCreated` datetime NOT NULL COMMENT '创建时间',
  `LastModified` datetime NOT NULL COMMENT '最后修改时间',
  `PropertyNames` longtext COMMENT '序列化属性名',
  `PropertyValues` longtext COMMENT '序列化属性值',
  PRIMARY KEY (`MedalId`),
  KEY `IX_tn_Medal_AwardStatus` (`AwardStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_medaltousers
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_medaltousers` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `MedalId` bigint(20) DEFAULT NULL,
  `UserId` bigint(20) DEFAULT NULL,
  `UserDisplayName` varchar(64) DEFAULT NULL,
  `ManagerId` bigint(20) DEFAULT NULL,
  `UserAwardStatus` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`Id`),
  KEY `ManagerId` (`ManagerId`),
  KEY `UserAwardStatus` (`UserAwardStatus`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_pointrechargeorders
-- ---------------------------
CREATE TABLE IF NOT EXISTS `tn_pointrechargeorders` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserId` bigint(20) DEFAULT NULL,
  `TradePoints` int(11) DEFAULT NULL,
  `TotalPrice` double DEFAULT NULL,
  `Buyway` int(11) DEFAULT NULL,
  `Description` varchar(255) DEFAULT NULL,
  `TradingAccount` varchar(255) DEFAULT NULL,
  `Status` int(11) DEFAULT NULL,
  `PayMediaType` int(11) DEFAULT NULL,
  `TradeNo` varchar(125) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`Id`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_pointtaskrecords
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_pointtaskrecords` (
  `RecordId` bigint(20) NOT NULL AUTO_INCREMENT,
  `TaskId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `UserDisplayName` varchar(64) NOT NULL,
  `Status` tinyint(4) NOT NULL,
  `ResultContent` longtext,
  `Feedback` longtext,
  `DateCreated` datetime NOT NULL,
  PRIMARY KEY (`RecordId`),
  KEY `IX_tn_PointTaskRecords_TaskId` (`TaskId`),
  KEY `IX_tn_PointTaskRecords_UserId` (`UserId`),
  KEY `IX_tn_PointTaskRecords_Status` (`Status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for tn_pointtasks
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_pointtasks` (
  `TaskId` bigint(20) NOT NULL AUTO_INCREMENT,
  `TypeId` bigint(20) NOT NULL,
  `TaskName` varchar(64) NOT NULL,
  `Description` text NOT NULL,
  `AwardPoints` int(11) NOT NULL,
  `AwardGolds` int(11) NOT NULL,
  `MinUserRank` int(11) NOT NULL,
  `MinCondition` int(11) DEFAULT NULL,
  `TasksSettings` longtext,
  `Deadline` datetime DEFAULT NULL,
  `Status` tinyint(4) NOT NULL,
  `DateCreated` datetime NOT NULL,
  PRIMARY KEY (`TaskId`),
  KEY `IX_tn_PointTasks_Status` (`Status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_pointtasktypes
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_pointtasktypes` (
  `TypeId` bigint(20) NOT NULL AUTO_INCREMENT,
  `TypeName` varchar(64) NOT NULL COMMENT '任务类型名称（连续签到、邀请朋友、站外分享、人工审核）',
  `IsShowProgressBar` tinyint(4) NOT NULL,
  `IsSetDeadline` tinyint(4) NOT NULL,
  `CanAddTask` tinyint(4) NOT NULL,
  `Description` text NOT NULL,
  `TaskUrl` varchar(255) DEFAULT NULL,
  `TaskUrlType` tinyint(4) DEFAULT NULL,
  `CheckMethodName` varchar(64) DEFAULT NULL,
  `RouteName` varchar(50) DEFAULT NULL,
  `ImageUrl` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`TypeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_searchwords
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_searchwords` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Word` varchar(64) DEFAULT NULL,
  `SearchTypeCode` varchar(32) DEFAULT NULL,
  `IsAddedByAdministrator` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LastModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`Id`),
  KEY `SearchTypeCode` (`SearchTypeCode`),
  KEY `Word` (`Word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_usersignins
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_usersignins` (
   `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserId` bigint(20) DEFAULT NULL,
  `TradePointSum` int(11) DEFAULT NULL,
  `ExperiencePointSum` int(11) DEFAULT NULL,
  `ContinuedSignCount` int(11) DEFAULT NULL,
  `MonthSignCount` int(11) DEFAULT NULL,
  `SignCount` int(11) DEFAULT NULL,
  `LastSignedIn` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`Id`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tn_usersignindetails
-- ----------------------------
CREATE TABLE IF NOT EXISTS `tn_usersignindetails` (
    `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserId` bigint(20) DEFAULT NULL,
  `TradePoints` int(11) DEFAULT NULL,
  `ExperiencePoints` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`Id`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `tn_pointrechargeorders` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_medalgroups` MODIFY COLUMN `DateCreated` datetime NOT NULL COMMENT '创建时间';
ALTER TABLE `tn_medals` MODIFY COLUMN `DateCreated` datetime NOT NULL COMMENT '创建时间';
ALTER TABLE `tn_medals` MODIFY COLUMN `LastModified` datetime NOT NULL COMMENT '最后修改时间';
ALTER TABLE `tn_medaltousers` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_pointtaskrecords` MODIFY COLUMN `DateCreated` datetime NOT NULL;
ALTER TABLE `tn_pointtasks` MODIFY COLUMN `Deadline` datetime DEFAULT NULL;
ALTER TABLE `tn_pointtasks` MODIFY COLUMN `DateCreated` datetime NOT NULL;
ALTER TABLE `spb_userprofiles` MODIFY COLUMN `Birthday` datetime NOT NULL;
ALTER TABLE `spb_userprofiles` MODIFY COLUMN `LunarBirthday` datetime NOT NULL;
ALTER TABLE `tn_accountbindings` MODIFY COLUMN `ExpiredDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_advertisings` MODIFY COLUMN `StartDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_advertisings` MODIFY COLUMN `EndDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_advertisings` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_attachmentaccessrecords` MODIFY COLUMN `LastDownloadDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_attachmentaccessrecords` MODIFY COLUMN `DownloadDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_attachments` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_categories` MODIFY COLUMN `LastModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_categories` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_comments` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_contentcategories` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_contentitems` MODIFY COLUMN `DatePublished` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_contentitems` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_contentitems` MODIFY COLUMN `LastModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_follows` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_follows` MODIFY COLUMN `LastContactDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_invitationcodes` MODIFY COLUMN `ExpiredDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_invitationcodes` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_invitefriendrecords` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_kvstore` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_links` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_messages` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_messagesessions` MODIFY COLUMN `LastModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_notices` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_notices` MODIFY COLUMN `LastSendDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_onlineusers` MODIFY COLUMN `LastActivityTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_onlineusers` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_operationlogs` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_pointrecords` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_reviews` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_sections` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_specialcontentitems` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_specialcontentitems` MODIFY COLUMN `ExpiredDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_tags` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_taskdetails` MODIFY COLUMN `LastStart` datetime NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_taskdetails` MODIFY COLUMN `LastEnd` datetime NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_taskdetails` MODIFY COLUMN `NextStart` datetime NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_taskdetails` MODIFY COLUMN `StartDate` datetime NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_taskdetails` MODIFY COLUMN `EndDate` datetime NULL ;
ALTER TABLE `tn_threads` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_threads` MODIFY COLUMN `LastModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_users` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_users` MODIFY COLUMN `LastActivityTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_users` MODIFY COLUMN `BanDeadline` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_impeachreports` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_searchwords` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_searchwords` MODIFY COLUMN `LastModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_usersignindetails` MODIFY COLUMN `DateCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `tn_usersignins` MODIFY COLUMN `LastSignedIn` datetime NOT NULL DEFAULT '0000-00-00 00:00:00';

INSERT INTO `tn_tenanttypesinservices` (`TenantTypeId`, `ServiceKey`) SELECT '000041', 'Count' FROM DUAL WHERE NOT EXISTS(SELECT 1 FROM tn_tenanttypesinservices WHERE TenantTypeId='000041' AND ServiceKey='Count' LIMIT 1); 

INSERT INTO `tn_taskdetails` ( `Name`, `TaskRule`, `ClassType`, `Enabled`, `RunAtRestart`, `IsRunning`, `LastStart`, `LastEnd`, `LastIsSuccess`, `NextStart`, `StartDate`, `EndDate`, `RunAtServer`) SELECT '重新统计计数（每天凌晨1点执行）', '0 0 1 * * ?', 'Tunynet.Common.ResetCountTask,Tunynet.Core', '1', '1', '0', NULL, NULL, '1', NULL, NULL, NULL, '0' FROM DUAL WHERE NOT EXISTS(SELECT 1 FROM tn_taskdetails WHERE ClassType='Tunynet.Common.ResetCountTask,Tunynet.Core' LIMIT 1);

UPDATE tn_PointTaskTypes SET TaskUrl='/setting' WHERE TypeId=3;

DROP PROCEDURE IF EXISTS schema_change;
DELIMITER $$ 
DROP PROCEDURE IF EXISTS schema_change$$
CREATE PROCEDURE schema_change()
BEGIN
IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'tn_pointrechargeorders' AND column_name = 'PayMediaType') THEN
    ALTER TABLE tn_pointrechargeorders ADD COLUMN PayMediaType  TINYINT NOT NULL;
ELSE    
    ALTER TABLE tn_pointrechargeorders MODIFY COLUMN PayMediaType TINYINT NOT NULL;
END IF; 

IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'tn_threads' AND column_name = 'ThreadType') THEN
    ALTER TABLE tn_threads ADD COLUMN ThreadType int(11) NULL;
ELSE    
    ALTER TABLE tn_threads MODIFY COLUMN ThreadType int(11) NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'tn_threads' AND column_name = 'AssociateId') THEN
    ALTER TABLE tn_threads ADD COLUMN AssociateId bigint(20) NULL;
ELSE    
    ALTER TABLE tn_threads MODIFY COLUMN AssociateId bigint(20) NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'tn_attachments' AND column_name = 'ConvertStatus') THEN
    ALTER TABLE tn_attachments ADD COLUMN ConvertStatus int(11) NOT NULL DEFAULT 0;
ELSE    
    ALTER TABLE tn_attachments MODIFY COLUMN ConvertStatus int(11) NOT NULL DEFAULT 0;
END IF;

END $$
DELIMITER ;
CALL schema_change();

DROP FUNCTION IF EXISTS Get_StrArrayLength;
CREATE FUNCTION Get_StrArrayLength (str VARCHAR(1024), split VARCHAR(10))
RETURNS INT
BEGIN
DECLARE location INT;
 DECLARE start INT;
 DECLARE length INT;
 SET str = ltrim(rtrim(str));
 SET location = locate(split,str);
 SET length=1;
  WHILE location<>0 DO
     SET start = location + 1;
     SET location=locate(split,str,start);
     SET length=length+1;
    END WHILE;
  RETURN length;
END;

DROP FUNCTION IF EXISTS Get_StrArrayStrOfIndex;
CREATE FUNCTION Get_StrArrayStrOfIndex (str VARCHAR(1024), split VARCHAR(10), i INT)
RETURNS VARCHAR(1024)
BEGIN
DECLARE location INT;
DECLARE start INT;
DECLARE next INT;
DECLARE seed INT;
SET str=ltrim(rtrim(str));
SET start=1;
SET next=1;
SET seed=CHAR_LENGTH(split);
SET location=locate(split,str);
WHILE location<>0 AND i>next DO
   SET start=location+seed;
   SET location=locate(split,str,start);
   SET next=next+1;
  END WHILE;
IF location = 0 THEN
SET location = CHAR_LENGTH(str)+1;
END IF;
-- 这儿存在两种情况：1、字符串不存在分隔符号 2、字符串中存在分隔符号，跳出while循环后，location为0，那默认为字符串后边有一个分隔符号。
RETURN substring(str,start,location-start);
END;

DROP PROCEDURE IF EXISTS UpdateAttachmentPosition;

DELIMITER $$
CREATE PROCEDURE UpdateAttachmentPosition()
BEGIN
    DECLARE attachmentId BIGINT;
    DECLARE tenantTypeId CHAR(6); 
    DECLARE associateId BIGINT;
    DECLARE isShowInAttachmentList INT;
    DECLARE propertyName LONGTEXT;
    DECLARE propertyValue LONGTEXT;
    DECLARE no_more_record INT DEFAULT 0;

    DECLARE next int;
    DECLARE length int;
    DECLARE name LONGTEXT;
    DECLARE start int;
    DECLARE end int;
    DECLARE finalPropertyName LONGTEXT;
    DECLARE finalPropertyValue LONGTEXT;

    DECLARE isExist INT;

    -- 定义一个游标 
    DECLARE attachment_cur cursor for SELECT A.AttachmentId, A.TenantTypeId, A.AssociateId, A.IsShowInAttachmentList, A.PropertyNames, A.PropertyValues FROM tn_attachments AS A;
    DECLARE  CONTINUE HANDLER FOR NOT FOUND  SET no_more_record = 1;

    -- 打开游标 
    OPEN attachment_cur;

    -- 读取游标 
    FETCH attachment_cur INTO attachmentId,tenantTypeId,associateId,isShowInAttachmentList,propertyName,propertyValue;
    WHILE no_more_record != 1  DO
        SET next = 1;
        SET length = Get_StrArrayLength(propertyName,':');
        SET finalPropertyName ='';

        IF Get_StrArrayStrOfIndex(propertyName,':',1)='Position' THEN
            WHILE next<length DO
                SET name=Get_StrArrayStrOfIndex(propertyName,':',next);
                SET start=Get_StrArrayStrOfIndex(propertyName,':',next+2);
                SET end=Get_StrArrayStrOfIndex(propertyName,':',next+3);

                IF start=0 THEN
                    SET finalPropertyName=CONCAT( finalPropertyName,name,':S:',LTRIM(CAST(start AS CHAR)),':',LTRIM(CAST(end+1 AS CHAR)),':');
                ELSE
                    SET finalPropertyName=CONCAT(finalPropertyName, name,':S:',LTRIM(CAST(start+1 AS CHAR)),':',LTRIM(CAST(end AS CHAR)),':');
                END IF;

                SET next=next+4;
            END WHILE;

            SET propertyName=finalPropertyName;

            IF  isShowInAttachmentList=1 THEN
                SET propertyValue = CONCAT('30',SUBSTR(propertyValue,2));
            ELSE
                -- 角色
                IF tenantTypeId='000002' THEN
                    SELECT 1
                    FROM tn_Roles
                    WHERE tn_Roles.RoleId=associateId AND tn_Roles.RoleImageAttachmentId=attachmentId INTO isExist;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 分类
                IF tenantTypeId='000021' THEN
                    SELECT 1
                    FROM tn_Categories
                    WHERE tn_Categories.CategoryId=associateId AND tn_Categories.ImageAttachmentId=attachmentId INTO isExist;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 推荐
                IF tenantTypeId='000061' THEN
                    SELECT 1
                    FROM tn_SpecialContentItems
                    WHERE tn_SpecialContentItems.Id=associateId AND tn_SpecialContentItems.FeaturedImageAttachmentId=attachmentId INTO isExist;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 友情链接
                IF tenantTypeId='000071' THEN
                    SELECT isExist
                    FROM tn_Links
                    WHERE tn_Links.LinkId=associateId AND tn_Links.ImageAttachmentId=attachmentId;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 广告位
                IF tenantTypeId='000082' THEN
                    SELECT isExist
                    FROM tn_AdvertisingPositions
                    WHERE tn_AdvertisingPositions.PositionId=associateId AND tn_AdvertisingPositions.ImageAttachmentId=attachmentId;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 广告
                IF tenantTypeId='000081' THEN
                    SELECT isExist
                    FROM tn_Advertisings
                    WHERE tn_Advertisings.AdvertisingId=associateId AND tn_Advertisings.ImageAttachmentId=attachmentId;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 勋章
                IF tenantTypeId='000151' THEN
                    SELECT isExist
                    FROM tn_Medals
                    WHERE tn_Medals.MedalId=associateId AND tn_Medals.ImageAttachmentId=attachmentId;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 贴吧
                IF tenantTypeId='100001' THEN
                    SELECT isExist
                    FROM tn_Sections
                    WHERE tn_Sections.SectionId=associateId AND tn_Sections.FeaturedImageAttachmentId=attachmentId;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 贴子
                IF tenantTypeId='100002' THEN
                    SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                END IF;

                -- 资讯
                IF tenantTypeId='100011' or tenantTypeId='100013' or tenantTypeId='100014' or tenantTypeId='100015' THEN
                    SELECT 1
                    FROM tn_ContentItems
                    WHERE tn_ContentItems.ContentItemId=associateId AND tn_ContentItems.FeaturedImageAttachmentId=attachmentId INTO isExist; 
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;


                -- 问题
                IF tenantTypeId='101301' THEN
                    SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                END IF;

                -- 回答
                IF tenantTypeId='101302' THEN
                    SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                END IF;

                -- 活动
                IF tenantTypeId='100011' THEN
                    SELECT 1
                    FROM spb_Events
                    WHERE spb_Events.Id=associateId AND spb_Events.ImageAttachmentId=attachmentId INTO isExist;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

                -- 投票
                IF tenantTypeId='101500' THEN
                    SELECT 1
                    FROM spb_Votes
                    WHERE spb_Votes.Id=associateId AND spb_Votes.ImageAttachmentId=attachmentId INTO isExist;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;
                
                -- 投票项
                IF tenantTypeId='101501' THEN
                    SELECT 1
                    FROM spb_Votes
                    WHERE spb_Votes.Id=associateId AND spb_Votes.ImageAttachmentId=attachmentId INTO isExist;
                    IF isExist=1 THEN
                        SET propertyValue=CONCAT('10',SUBSTR(propertyValue,2));
                    ELSE
                        SET propertyValue=CONCAT('20',SUBSTR(propertyValue,2));
                    END IF;
                END IF;

            END IF;

            UPDATE tn_Attachments SET tn_Attachments.PropertyNames=propertyName ,tn_Attachments.PropertyValues=propertyValue WHERE tn_Attachments.AttachmentId=attachmentId;

        END IF;

        -- 为了防止 mysql 中游标因为内部获取出来的内容为空导致游标断掉的bug
        SET no_more_record=0;
        -- 读取游标 
        FETCH attachment_cur INTO attachmentId,tenantTypeId,associateId,isShowInAttachmentList,propertyName,propertyValue;

     END WHILE;
    CLOSE attachment_cur;
END $$
DELIMITER ;
CALL UpdateAttachmentPosition();