﻿IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_ImpeachReports]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_ImpeachReports]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_ImpeachReports](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[TenantTypeId] [nchar](6) NOT NULL,
	[ReportObjectId] [bigint] NOT NULL,
	[UserId] [bigint] NOT NULL,
	[Reporter] [nvarchar](64) NOT NULL,
	[Reason] [tinyint] NOT NULL,
	[Title] [nvarchar](500) NULL,
	[Description] [nvarchar](255) NULL,
	[Status] [tinyint] NOT NULL,
	[DateCreated] [datetime] NOT NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[tn_ImpeachReports] ADD  DEFAULT ((0)) FOR [ReportObjectId]
ALTER TABLE [dbo].[tn_ImpeachReports] ADD  DEFAULT ((99)) FOR [Reason]
ALTER TABLE [dbo].[tn_ImpeachReports] ADD  DEFAULT ((0)) FOR [Status]

END

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_MedalConditions]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_MedalConditions]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_MedalConditions](
	[ConditionId] [bigint] IDENTITY(1,1) NOT NULL,
	[ConditionName] [nvarchar](64) NOT NULL,
	[DisplayOrder] [bigint] NOT NULL,
	[MethodName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_tn_MedalConditions] PRIMARY KEY CLUSTERED 
(
	[ConditionId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'条件Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalConditions', @level2type=N'COLUMN',@level2name=N'ConditionId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'条件名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalConditions', @level2type=N'COLUMN',@level2name=N'ConditionName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章条件显示排序' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalConditions', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'验证方法名（接收最小条件值和验证用户id）' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalConditions', @level2type=N'COLUMN',@level2name=N'MethodName'
END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_MedalGroups]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_MedalGroups]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_MedalGroups](
	[GroupId] [bigint] IDENTITY(1,1) NOT NULL,
	[GroupName] [nvarchar](64) NOT NULL,
	[MeadlCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_MedalGroup] PRIMARY KEY CLUSTERED 
(
	[GroupId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章互斥组表' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalGroups', @level2type=N'COLUMN',@level2name=N'GroupId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章互斥组名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalGroups', @level2type=N'COLUMN',@level2name=N'GroupName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章数' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalGroups', @level2type=N'COLUMN',@level2name=N'MeadlCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalGroups', @level2type=N'COLUMN',@level2name=N'DateCreated'
ALTER TABLE [dbo].[tn_MedalGroups] ADD  CONSTRAINT [DF_tn_MedalGroup_MeadlCount]  DEFAULT ((0)) FOR [MeadlCount]

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_MedalInConditions]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_MedalInConditions]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_MedalInConditions](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[MedalId] [bigint] NOT NULL,
	[ConditionId] [bigint] NOT NULL,
	[MinCondition] [int] NOT NULL,
 CONSTRAINT [PK_tn_MedalInConditions] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最小条件' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalInConditions', @level2type=N'COLUMN',@level2name=N'MinCondition'
END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_MedalInGroups]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_MedalInGroups]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_MedalInGroups](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[MedalId] [bigint] NOT NULL,
	[GroupId] [bigint] NOT NULL,
 CONSTRAINT [PK_tn_MedalInGroup] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_Medals]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_Medals]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_Medals](
	[MedalId] [bigint] IDENTITY(1,1) NOT NULL,
	[MedalName] [nvarchar](64) NOT NULL,
	[AwardStatus] [tinyint] NOT NULL,
	[AwardType] [tinyint] NOT NULL,
	[ImageAttachmentId] [bigint] NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [bigint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[PropertyNames] [nvarchar](max) NULL,
	[PropertyValues] [nvarchar](max) NULL,
 CONSTRAINT [PK_tn_Medal] PRIMARY KEY CLUSTERED 
(
	[MedalId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'MedalId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'MedalName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'授予状态（可以授予、停止授予）' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'AwardStatus'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'授予方式（自主申请、人工授予）' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'AwardType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章标题图ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'ImageAttachmentId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'描述' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'Description'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章显示排序' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'DateCreated'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后修改时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'LastModified'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'序列化属性名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'PropertyNames'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'序列化属性值' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_Medals', @level2type=N'COLUMN',@level2name=N'PropertyValues'

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_MedalToUsers]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_MedalToUsers]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_MedalToUsers](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[MedalId] [bigint] NOT NULL,
	[UserId] [bigint] NOT NULL,
	[UserDisplayName] [nvarchar](64) NOT NULL,
	[ManagerId] [bigint] NOT NULL,
	[UserAwardStatus] [tinyint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_MedalToUser] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'Id'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'勋章Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'MedalId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'UserId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户显示名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'UserDisplayName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'操作者Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'ManagerId'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户授予状态（已授予、已收回、已拒绝、申请中、已取消、已放弃）' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'UserAwardStatus'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_MedalToUsers', @level2type=N'COLUMN',@level2name=N'DateCreated'

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_PointRechargeOrders]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_PointRechargeOrders]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_PointRechargeOrders](
	[Id] [bigint] NOT NULL,
	[UserId] [bigint] NOT NULL,
	[TradePoints] [int] NULL,
	[TotalPrice] [float] NOT NULL,
	[Buyway] [tinyint] NOT NULL,
	[Description] [nvarchar](255) NOT NULL,
	[TradingAccount] [nvarchar](255) NOT NULL,
	[Status] [tinyint] NOT NULL,
	[TradeNo] [nvarchar](125) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_PointRechargeOrders_UserId] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_PointTaskRecords]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_PointTaskRecords]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_PointTaskRecords](
	[RecordId] [bigint] IDENTITY(1,1) NOT NULL,
	[TaskId] [bigint] NOT NULL,
	[UserId] [bigint] NOT NULL,
	[UserDisplayName] [nvarchar](64) NOT NULL,
	[Status] [tinyint] NOT NULL,
	[ResultContent] [nvarchar](max) NULL,
	[Feedback] [nvarchar](max) NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_PointTaskRecords] PRIMARY KEY CLUSTERED 
(
	[RecordId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_PointTasks]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_PointTasks]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_PointTasks](
	[TaskId] [bigint] IDENTITY(1,1) NOT NULL,
	[TypeId] [bigint] NOT NULL,
	[TaskName] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[AwardPoints] [int] NOT NULL,
	[AwardGolds] [int] NOT NULL,
	[MinUserRank] [int] NOT NULL,
	[MinCondition] [int] NULL,
	[TasksSettings] [nvarchar](max) NULL,
	[Deadline] [datetime] NULL,
	[Status] [tinyint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_PointTasks] PRIMARY KEY CLUSTERED 
(
	[TaskId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_PointTaskTypes]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_PointTaskTypes]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_PointTaskTypes](
	[TypeId] [bigint] IDENTITY(1,1) NOT NULL,
	[TypeName] [nvarchar](64) NOT NULL,
	[IsShowProgressBar] [tinyint] NOT NULL,
	[IsSetDeadline] [tinyint] NOT NULL,
	[CanAddTask] [tinyint] NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[TaskUrl] [nvarchar](255) NULL,
	[TaskUrlType] [tinyint] NULL,
	[CheckMethodName] [nvarchar](64) NULL,
	[RouteName] [nvarchar](50) NULL,
	[ImageUrl] [nvarchar](50) NULL,
 CONSTRAINT [PK_tn_PointTaskTypes] PRIMARY KEY CLUSTERED 
(
	[TypeId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'任务类型名称（连续签到、邀请朋友、站外分享、人工审核）' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'tn_PointTaskTypes', @level2type=N'COLUMN',@level2name=N'TypeName'
END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_SearchWords]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_SearchWords]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
CREATE TABLE [dbo].[tn_SearchWords](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[Word] [nvarchar](64) NOT NULL,
	[SearchTypeCode] [varchar](32) NOT NULL,
	[IsAddedByAdministrator] [tinyint] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_SearchWords] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
SET ANSI_PADDING OFF
END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_UserSignIns]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_UserSignIns]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_UserSignIns](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[UserId] [bigint] NOT NULL,
	[TradePointSum] [int] NOT NULL,
	[ExperiencePointSum] [int] NOT NULL,
	[ContinuedSignCount] [int] NOT NULL,
	[MonthSignCount] [int] NOT NULL,
	[SignCount] [int] NOT NULL,
	[LastSignedIn] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_UserSignIns] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[tn_UserSignIns] ADD  CONSTRAINT [DF_tn_UserSignIns_TradePointSum]  DEFAULT ((0)) FOR [TradePointSum]
ALTER TABLE [dbo].[tn_UserSignIns] ADD  CONSTRAINT [DF_tn_UserSignIns_ExperiencePointSum]  DEFAULT ((0)) FOR [ExperiencePointSum]
ALTER TABLE [dbo].[tn_UserSignIns] ADD  CONSTRAINT [DF_tn_UserSignIns_ContinuedSignCount]  DEFAULT ((0)) FOR [ContinuedSignCount]
ALTER TABLE [dbo].[tn_UserSignIns] ADD  CONSTRAINT [DF_tn_UserSignIns_MonthSignCoun]  DEFAULT ((0)) FOR [MonthSignCount]

END


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[tn_UserSignInDetails]') AND OBJECTPROPERTY(ID, 'IsTable') = 1) 
BEGIN
/****** Object:  Table [dbo].[tn_UserSignInDetails]    Script Date: 2019/2/18 17:40:48 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[tn_UserSignInDetails](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[UserId] [bigint] NOT NULL,
	[TradePoints] [int] NOT NULL,
	[ExperiencePoints] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_tn_UserSignInDetails] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[tn_UserSignInDetails] ADD  CONSTRAINT [DF_tn_UserSignInDetails_TradePoints]  DEFAULT ((0)) FOR [TradePoints]
ALTER TABLE [dbo].[tn_UserSignInDetails] ADD  CONSTRAINT [DF_tn_UserSignInDetails_ExperiencePoints]  DEFAULT ((0)) FOR [ExperiencePoints]
END
GO

IF NOT EXISTS (SELECT * FROM tn_TenantTypesInServices WHERE  TenantTypeId='000041' AND ServiceKey='Count')
BEGIN
    INSERT INTO tn_TenantTypesInServices (TenantTypeId, ServiceKey) VALUES ('000041', 'Count');
END
GO

IF NOT EXISTS (SELECT * FROM tn_TaskDetails WHERE ClassType='Tunynet.Common.ResetCountTask,Tunynet.Core')
BEGIN
    INSERT INTO tn_TaskDetails (Name, TaskRule, ClassType, Enabled, RunAtRestart, IsRunning, LastStart, LastEnd, LastIsSuccess, NextStart, StartDate, EndDate, RunAtServer) VALUES ('重新统计计数（每天凌晨1点执行）', '0 0 1 * * ?', 'Tunynet.Common.ResetCountTask,Tunynet.Core', '1', '1', '0', NULL, NULL, '1', NULL, NULL, NULL, '0');
END
GO

IF NOT EXISTS (SELECT * FROM syscolumns WHERE id=object_id('tn_PointRechargeOrders') AND NAME='PayMediaType')
BEGIN
    ALTER TABLE tn_PointRechargeOrders ADD PayMediaType TINYINT NOT NULL DEFAULT 0
END
GO

IF NOT EXISTS (SELECT * FROM syscolumns WHERE id=object_id('tn_Threads') AND NAME='ThreadType')
BEGIN
    ALTER TABLE tn_Threads ADD ThreadType TINYINT NULL
END
GO

IF NOT EXISTS (SELECT * FROM syscolumns WHERE id=object_id('tn_Threads') AND NAME='AssociateId')
BEGIN
    ALTER TABLE tn_Threads ADD AssociateId BIGINT NULL
END
GO

IF NOT EXISTS (SELECT * FROM syscolumns WHERE id=object_id('tn_Attachments') AND NAME='ConvertStatus')
BEGIN
    ALTER TABLE tn_Attachments ADD ConvertStatus TINYINT NOT NULL DEFAULT 0
END
GO

UPDATE tn_PointTaskTypes SET TaskUrl='/setting' WHERE TypeId=3
GO

IF EXISTS(SELECT name FROM sysobjects WHERE NAME = 'Get_StrArrayLength' AND TYPE='FN')
DROP FUNCTION Get_StrArrayLength
GO
CREATE function Get_StrArrayLength
(
@str VARCHAR(1024),  -- 要分割的字符串
@split VARCHAR(10)  -- 分隔符号
)
RETURNS INT
AS
BEGIN
 DECLARE @location INT
 DECLARE @start INT
 DECLARE @length INT
 SET @str=ltrim(rtrim(@str))
 SET @location=charindex(@split,@str)
 SET @length=1
  WHILE @location<>0
    BEGIN
     SET @start=@location+1
     SET @location=charindex(@split,@str,@start)
     SET @length=@length+1
    END
  RETURN @length
END
GO

IF EXISTS(SELECT name FROM sysobjects WHERE NAME = 'Get_StrArrayStrOfIndex' AND TYPE='FN')
DROP FUNCTION Get_StrArrayStrOfIndex
GO
CREATE FUNCTION Get_StrArrayStrOfIndex
(
@str VARCHAR(1024),  -- 要分割的字符串
@split VARCHAR(10),  -- 分隔符号
@index INT -- 取第几个元素
)
RETURNS VARCHAR(1024)
AS
BEGIN
DECLARE @location INT
DECLARE @start INT
DECLARE @next INT
DECLARE @seed INT
SET @str=ltrim(rtrim(@str))
set @start=1
SET @next=1
SET @seed=len(@split)
set @location=charindex(@split,@str)
WHILE @location<>0 AND @index>@next
  BEGIN
   SET @start=@location+@seed
   SET @location=charindex(@split,@str,@start)
   SET @next=@next+1
  END
IF @location =0 SELECT @location =len(@str)+1

-- 这儿存在两种情况：1、字符串不存在分隔符号 2、字符串中存在分隔符号，跳出while循环后，@location为0，那默认为字符串后边有一个分隔符号。
RETURN substring(@str,@start,@location-@start)
END
GO

IF EXISTS(SELECT name FROM sysobjects WHERE NAME = 'UpdateAttachmentPosition' AND TYPE='P')
DROP PROCEDURE UpdateAttachmentPosition
GO

CREATE PROCEDURE UpdateAttachmentPosition
AS
DECLARE @attachmentId BIGINT, @tenantTypeId CHAR(6),@associateId BIGINT,@isShowInAttachmentList TINYINT, @propertyName NVARCHAR(Max), @propertyValue NVARCHAR(Max)
-- 定义一个游标 
DECLARE attachment_cur cursor SCROLL for SELECT AttachmentId, TenantTypeId, AssociateId, IsShowInAttachmentList, PropertyNames, PropertyValues
FROM tn_Attachments
-- 打开游标 
OPEN attachment_cur
-- FETCH FIRST FROM attachment_cur INTO @attachmentId,@tenantTypeId,@propertyName,@propertyValue
DECLARE @status INT=0
WHILE @status=0 
BEGIN
    -- 读取游标 
    FETCH NEXT FROM attachment_cur INTO @attachmentId,@tenantTypeId,@associateId,@isShowInAttachmentList,@propertyName,@propertyValue
    SET @status=@@FETCH_STATUS

    declare @next int,@length int,@name NVARCHAR(Max),@start int,@end int,@finalPropertyName varchar(Max),@finalPropertyValue varchar(Max)
    set @next=1
    set @length=dbo.Get_StrArrayLength(@propertyName,':')
	set @finalPropertyName=''

    IF dbo.Get_StrArrayStrOfIndex(@propertyName,':',1)='Position' 
		BEGIN
        WHILE @next<@length
        BEGIN
            SET @name=dbo.Get_StrArrayStrOfIndex(@propertyName,':',@next)
            SET @start=dbo.Get_StrArrayStrOfIndex(@propertyName,':',@next+2)
            SET @end=dbo.Get_StrArrayStrOfIndex(@propertyName,':',@next+3)

            IF @start=0
            BEGIN
                SET @finalPropertyName=@finalPropertyName+ @name+':S:'+ LTRIM( Str(@start,10,0))+':'+LTRIM(Str(@end+1,10,0))+':'
            END
            ELSE
            BEGIN
                SET @finalPropertyName=@finalPropertyName+ @name+':S:'+LTRIM(Str(@start+1,10,0))+':'+LTRIM(Str(@end,1,0))+':'
            END
            SET @next=@next+4
        END
		SET @propertyName=@finalPropertyName

        DECLARE @isExist TINYINT

        IF  @isShowInAttachmentList=1
        BEGIN
            SET @propertyValue=STUFF(@propertyValue,1,1,'30')
        END
        ELSE 
        BEGIN
            -- 贴子
            IF @tenantTypeId='100002'
            BEGIN
                SELECT *
                FROM tn_Threads
                WHERE ThreadId=@associateId
            END
            -- 资讯
            IF @tenantTypeId='100011'
            BEGIN
                SELECT @isExist
                FROM tn_ContentItems
                WHERE ContentItemId=@associateId AND FeaturedImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 角色
            IF @tenantTypeId='000002'
            BEGIN
                SELECT @isExist
                FROM tn_Roles
                WHERE RoleId=@associateId AND RoleImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 分类
            IF @tenantTypeId='000021'
            BEGIN
                SELECT @isExist
                FROM tn_Categories
                WHERE CategoryId=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 推荐
            IF @tenantTypeId='000061'
            BEGIN
                SELECT @isExist
                FROM tn_SpecialContentItems
                WHERE Id=@associateId AND FeaturedImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 友情链接
            IF @tenantTypeId='000071'
            BEGIN
                SELECT @isExist
                FROM tn_Links
                WHERE LinkId=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 广告位
            IF @tenantTypeId='000082'
            BEGIN
                SELECT @isExist
                FROM tn_AdvertisingPositions
                WHERE PositionId=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 广告
            IF @tenantTypeId='000081'
            BEGIN
                SELECT @isExist
                FROM tn_Advertisings
                WHERE AdvertisingId=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 勋章
            IF @tenantTypeId='000151'
            BEGIN
                SELECT @isExist
                FROM tn_Medals
                WHERE MedalId=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 贴吧
            IF @tenantTypeId='100001'
            BEGIN
                SELECT @isExist
                FROM tn_Sections
                WHERE SectionId=@associateId AND FeaturedImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 贴子
            IF @tenantTypeId='100002'
            BEGIN
                SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 资讯
            IF @tenantTypeId='100011' or @tenantTypeId='100013' or @tenantTypeId='100014' or @tenantTypeId='100015'
            BEGIN
                SELECT @isExist
                FROM tn_ContentItems
                WHERE ContentItemId=@associateId AND FeaturedImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END


            -- 问题
            IF @tenantTypeId='101301'
            BEGIN
                SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 回答
            IF @tenantTypeId='101302'
            BEGIN
                SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 活动
            IF @tenantTypeId='100011'
            BEGIN
                SELECT @isExist
                FROM spb_Events
                WHERE Id=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

            -- 投票
            IF @tenantTypeId='101500'
            BEGIN
                SELECT @isExist
                FROM spb_Votes
                WHERE Id=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END
            
            -- 投票项
            IF @tenantTypeId='101501'
            BEGIN
                SELECT @isExist
                FROM spb_Votes
                WHERE Id=@associateId AND ImageAttachmentId=@attachmentId
                IF @isExist=1
                    SET @propertyValue=STUFF(@propertyValue,1,1,'10')
                ELSE
                    SET @propertyValue=STUFF(@propertyValue,1,1,'20')
            END

        END

        UPDATE tn_Attachments SET PropertyNames=@propertyName ,PropertyValues=@propertyValue WHERE AttachmentId=@attachmentId

    END

    PRINT @attachmentId
    PRINT @tenantTypeId
    PRINT @propertyName
    PRINT @propertyValue
END

CLOSE attachment_cur

-- 摧毁游标 
DEALLOCATE attachment_cur
GO

EXECUTE UpdateAttachmentPosition 
GO