// window.UEDITOR_HOME_URL = './lib/ueditor/';
// ueditor依赖
require(['ZeroClipboard'], function (ZeroClipboard) {
    window.ZeroClipboard = ZeroClipboard;
});

+
    function (factory) {
        if (typeof define === "function" && define.amd) {
            require(['jquery', 'uploader', 'layer', 'ueditor', 'livequery', 'qqFace'], factory);
        } else if (typeof module === "object" && module.exports) {
            module.exports = factory(require('jquery'), require('uploader'), require('layer'), require('ueditor'), require('livequery'), require('qqFace'));
        } else {
            factory(jQuery, uploader, layer);
        }
    }(function ($, uploader, layer) {
        $(function () {
            var isChrome = window.navigator.userAgent.indexOf("Chrome") !== -1;
            var html = '<div id="myModal" class="modal fade"  tabindex="-1" role="dialog" aria-labelledby="myModalLabel">' +
                '<div class="modal-dialog" role="document">' +
                '<div id="modalcontent" class="modal-content">' +
                '</div></div></div>';

            $('[data-editor-wnd="uploadfile"] [data-uploader-item][data-response]').livequery(function () {
                var $this = $(this);
                var resp = $this.data('response');
                if (resp.MessageType === -1) return;
                var $delete = $('<a style="float:right;cursor: pointer;">删除</a>');
                $delete.on('click', function () {
                    var attachmentId = resp.attachmentId;
                    var fdId = $this.attr('id');
                    var param = $.param({
                        attachmentId: attachmentId,
                        t: new Date().getTime()
                    }, true);
                    delete window[$this.parent('[data-export]').data('export')][fdId];
                    $this.remove();

                    //不再访问服务器，做假删除，在提交表单时统一提交
                    //$.post('/controlpanel/_deleteattachments', param, function (data) {
                    //    if (data.MessageType) {
                    //        layer.msg(data.MessageContent, {
                    //            icon: 1
                    //        });
                    //        delete window[$this.parent('[data-export]').data('export')][fdId];
                    //        $this.remove();
                    //    } else {
                    //        layer.msg(data.MessageContent, {
                    //            icon: 2
                    //        });
                    //    }
                    //});
                });
                $this.find('b').before($delete);
            });

            function registerUploadFile(editorId, fileUploadUrl) {
                UE.registerUI('tn_uploadfile' + editorId, function (editor, uiName) {
                    var $ue = $(editor.container);
                    var $container = $ue.parent();
                    var data = window['ueditor#' + editor.key + '.data'];
                    //var fileUploadUrl = $container.data('uploader-file-uploadurl') || data.fileUploadUrl;
                    var ownerid = $container.data('uploader-ownerid') || data.ownerId;
                    var tenanttypeid = $container.data('uploader-tenanttypeid') || data.tenantTypeId;
                    var associateid = $container.data('uploader-associateid') || data.associateId;
                    var extensions = $container.data('uploader-extensions') || data.extensions;
                    var UIOption = {
                        name: '上传附件',
                        cssRules: 'background-position: -622px -40px;',
                        content: '<div data-editor-wnd="uploadfile">' +
                            '<button ' +
                            'class="btn btn-default" type="submit" ' +
                            'id="' + editor.key + '_uploadfile" ' +
                            'data-plugin="fileuploader" ' +
                            'data-auto-upload="true" ' +
                            'data-uploadurl="' + (fileUploadUrl || '/Common/UploadFiles') + '" ' +
                            'data-maxcount="1" ' +
                            'data-multiple="true" ' +
                            'data-isueditor="true" ' +
                            'data-ownerid="' + ownerid + '" ' +
                            'data-tenanttypeid="' + (tenanttypeid) + '" ' +
                            'data-associateid="' + associateid + '" ' +
                            'data-extensions="' + (extensions || '*') + '" ' +
                            'data-progress-id="' + editor.key + '_file-progress" ' +
                            '>选择文件上传</button>' +
                            '<div style="text-align:  center;">' +
                            '<hr>' +
                            '<span style="position: relative;top: -30px;background-color: white;">已上传文件</span>' +
                            '</div>' +
                            '<div id="' + editor.key + '_file-progress"></div>' +
                            '</div>'
                        //'<div style="position: absolute;bottom: 0px;width: 94%;margin: 16px 0;">' +
                        //'<button class="btn btn-primary pull-right btn-close" >确定</button>' +
                        //'</div>'
                    };

                    //创建一个button
                    var btn = new UE.ui.Button({
                        name: uiName,
                        title: UIOption.name,
                        cssRules: UIOption.cssRules,
                        onclick: function () {
                            var wndId = layer.open({
                                type: 1,
                                title: UIOption.name,
                                area: ['550px', '610px'], //宽高
                                content: UIOption.content,
                                btn: ["确定"],
                                yes: function () {
                                    layer.close(wndId);
                                },
                                scrollbars: true
                            });
                            //var $wnd = $('#layui-layer' + wndId);
                            //$wnd.find('.btn-close').click(function () {
                            //    layer.close(wndId);
                            //});
                        }
                    });

                    //当点到编辑内容上时，按钮要做的状态反射
                    editor.addListener('selectionchange', function () {
                        var state = editor.queryCommandState(uiName);
                        if (state == -1) {
                            btn.setDisabled(true);
                            btn.setChecked(false);
                        } else {
                            btn.setDisabled(false);
                            btn.setChecked(state);
                        }
                    });

                    return btn;
                }, undefined, editorId);
            }

            function registerUploadImage(editorId, imageUploadUrl) {
                // 上传附件 上传图片
                UE.registerUI('tn_uploadimage' + editorId, function (editor, uiName) {
                    var $ue = $(editor.container);
                    var $container = $ue.parent();
                    var data = window['ueditor#' + editor.key + '.data'];
                    //var imageUploadUrl = $container.data('uploader-image-uploadurl') || data.imageUploadUrl;
                    var ownerid = $container.data('uploader-ownerid') || data.ownerId;
                    var tenanttypeid = $container.data('uploader-tenanttypeid') || data.tenantTypeId;
                    var associateid = $container.data('uploader-associateid') || data.associateId;
                    var extensions = $container.data('uploader-extensions') || data.extensions;
                    var UIOption = {
                        name: '上传图片',
                        cssRules: 'background-position: -726px -77px;',
                        content: '<div style="margin-left:6px;max-height:475px;width:557px;overflow-y:auto">' +
                            '<span' +
                            ' style="margin-right:15px;width:120px;height:120px;background:#F6F6F6;color:#E5E5E5;border:#E5E5E5 1px solid;display:inline-block;line-height:106px;font-size:67px;text-align:center;font-weight:bold;cursor:pointer;"' +
                            ' id="' + editor.key + '_uploadimage"' +
                            ' data-plugin="fileuploader"' +
                            ' data-auto-upload="true"' +
                            ' data-uploadurl="' + (imageUploadUrl || '/Common/UploadFilesImg') + '"' +
                            ' data-maxcount="1"' +
                            ' data-multiple="true"' +
                            ' data-isueditor="true" ' +
                            ' data-ownerid="' + ownerid + '"' +
                            ' data-tenanttypeid="' + (tenanttypeid) + '"' +
                            ' data-associateid="' + associateid + '"' +
                            ' data-extensions="jpg,jpeg,png,gif"' +
                            ' data-exportvalue="##uploadedImage_' + editor.key + '"' +
                            ' data-preview="true"' +
                            ' data-selectable="true"' +
                            ' data-progress-id="' + editor.key + '_file-progress"' +
                            '>+</span>' +
                            '<span id="' + editor.key + '_file-progress"></span>' +
                            '</div>' +
                            '<div style="position: absolute;bottom: 0px;width: 94%;margin: 16px 0;">' +
                            '<a data-insertweb style="line-height: 34px;">插入网络图片</a>' +
                            '<button data-insert class="btn btn-default" style="float: right">插入所选图片</button>' +
                            '</div>'
                    };

                    //创建一个button
                    var btn = new UE.ui.Button({
                        name: 'tn_uploadimage',
                        title: UIOption.name,
                        cssRules: UIOption.cssRules,
                        onclick: function () {
                            var wndId = layer.open({
                                type: 1,
                                title: UIOption.name,
                                area: ['580px', '610px'], //宽高
                                content: UIOption.content
                            });
                            var $wnd = $('#layui-layer' + wndId);
                            $wnd.find('[data-insertweb]').click(function () {
                                layer.close(wndId);
                                var childWndId = layer.open({
                                    type: 1,
                                    title: '插入网络图片',
                                    area: ['580px', '500px'], //宽高
                                    content: '<form class="form-horizontal">' +
                                        '<div class="form-group">' +
                                        '<label class="col-xs-2 control-label">地址：</label>' +
                                        '<div class="col-xs-10"><input data-field="url" type="text" class="form-control"></div></div>' +
                                        '<div class="form-group">' +
                                        '<label class="col-xs-2 control-label">大小：</label>' +
                                        '<div class="col-xs-10">' +
                                        '<div style="display:inline-block">宽度：<input data-field="width" type="text" class="form-control" style="width:55px;display:inline">px </div> ' +
                                        '<div style="display:inline-block"> 高度：<input data-field="height" type="text" class="form-control" style="width:55px;display:inline">px </div>' +
                                        '</div></div>' +
                                        '</form>' +
                                        '<div style="background:#EEE"><img style="height:250px"></div>' +
                                        '<button class="btn btn-default" style="position:absolute;right:15px;bottom:20px;">插入图片</button>',
                                });
                                var $childWnd = $('#layui-layer' + childWndId);
                                $childWnd.find('[data-field=url]').on('blur', function () {
                                    $childWnd.find('img').attr('src', $(this).val());
                                });
                                $childWnd.find('button').click(function () {
                                    var url = $childWnd.find('input[data-field=url]').val();
                                    var width = $childWnd.find('input[data-field=width]').val();
                                    var height = $childWnd.find('input[data-field=height]').val();
                                    editor.execCommand('insertimage', {
                                        src: url,
                                        width: width,
                                        height: height
                                    });
                                    layer.close(childWndId);
                                });
                            });
                            $wnd.find('[data-insert]').click(function () {
                                var images = window['##uploadedImage_' + editor.key];
                                var count = 0;
                                for (i in images) {
                                    var img = images[i];
                                    if (!img.selected) continue;
                                    var attachmentId = JSON.parse(img.response).attachmentId;
                                    var rawSrc = JSON.parse(img.response).rawUrl;
                                    count++;
                                    editor.execCommand('insertimage', {
                                        src: img.url,
                                        attachmentId: attachmentId,
                                        rawSrc:rawSrc
                                    });
                                }
                                if (count === 0) {
                                    layer.confirm('请选择要插入到编辑器中的图片!', {
                                        btn: ['确认'],
                                    });
                                    return;
                                }
                                layer.close(wndId);
                            });
                        }
                    });

                    //当点到编辑内容上时，按钮要做的状态反射
                    editor.addListener('selectionchange', function () {
                        var state = editor.queryCommandState(uiName);
                        if (state == -1) {
                            btn.setDisabled(true);
                            btn.setChecked(false);
                        } else {
                            btn.setDisabled(false);
                            btn.setChecked(state);
                        }
                    });

                    return btn;
                }, undefined, editorId);
            }
            // 插入表情
            function registerInsertFace(editorId, facePath) {
                UE.registerUI('tn_insertface' + editorId, function (editor, uiName) {
                    var $ue = $(editor.container);
                    var $container = $ue.parent();
                    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
                    editor.registerCommand(uiName, {
                        execCommand: function () {
                            var wndId = layer.open({
                                type: 1,
                                area: ['580px', '610px'], //宽高
                            });
                        }
                    });

                    //创建一个button
                    var btn = new UE.ui.Button({
                        name: 'tn_insertface',
                        title: '插入表情',
                        cssRules: 'background-position: -61px -20px;',
                        onclick: function () {
                            var json = [
                                '', '惊讶', '撇嘴', '色', '发呆', '得意', '害羞', '闭嘴', '睡', '大哭', '尴尬', '发怒', '调皮', '呲牙', '微笑', '难过', '酷', '抓狂', '吐', '偷笑', '可爱', '白眼', '傲慢', '饥饿', '困', '恐惧', '流汗', '憨笑', '大兵', '奋斗', '咒骂', '嘘', '晕', '衰', '骷髅', '敲打', '再见', '发抖', '爱情', '跳跳', '猪头', '拥抱', '蛋糕', '闪电', '炸弹', '刀', '足球', '便便', '咖啡', '饭', '玫瑰', '凋谢', '爱心', '心碎', '礼物', '太阳', '月亮', '强', '弱', '握手', '飞吻', '怄火', '西瓜', '冷汗', '抠鼻', '鼓掌', '糗大了', '坏笑', '左哼哼', '右哼哼', '哈欠', '鄙视', '委屈', '快哭了', '阴险', '亲亲', '吓', '可怜', '菜刀', '啤酒', '篮球', '乒乓', '示爱', '瓢虫', '抱拳', '勾引', '拳头', '差劲', '爱你', 'NO', 'OK', '转圈', '磕头', '回头', '跳绳', '挥手', '激动', '街舞', '接吻', '左太极', '右太极'
                            ];
                            facePath = facePath || '/img/Emotions/default/';
                            var strFace = '<table border="0" cellspacing="0" cellpadding="0" style="float: left;"><tr>';
                            for (var i = 1; i <= 100; i++) {
                                strFace += '<td><img data-faceid="' + i + '" title="' + json[i] + '" src="' + facePath + i + '.gif"/></td>';
                                if (i % 10 === 0) strFace += '</tr><tr>';
                            }
                            strFace += '</tr></table>';
                            strFace += '<div class="emotionItem" style="display:none;"></div>';
                            var pos = this.target.getBoundingClientRect();
                            var wndId = layer.open({
                                type: 1,
                                title: null,
                                closeBtn: 0,
                                resize: false,
                                offset: [pos.y + 30, pos.x],
                                shade: [0.0001, '#FFF'],
                                shadeClose: true,
                                area: ['275px', '275px'], //宽高
                                content: strFace
                            });
                            var $wnd = $('#layui-layer' + wndId);
                            $wnd.css({
                                'min-width': '275px'
                            });
                            var $content = $wnd.find('.layui-layer-content');
                            $content.find('[data-faceid]').on('click', function () {
                                editor.execCommand('inserthtml', '[' + json[$(this).data('faceid')] + ']');
                                layer.close(wndId);
                            });
                        },

                    });

                    //当点到编辑内容上时，按钮要做的状态反射
                    editor.addListener('selectionchange', function () {
                        var state = editor.queryCommandState(uiName);
                        if (state == -1) {
                            btn.setDisabled(true);
                            btn.setChecked(false);
                        } else {
                            btn.setDisabled(false);
                            btn.setChecked(state);
                        }
                    });

                    return btn;
                }, undefined, editorId);
            }
            UE.Editor.prototype._bkGetActionUrl = UE.Editor.prototype.getActionUrl;
            //UE.Editor.prototype.getActionUrl = function (action) {
            //    if (action == 'uploadimage' || action == 'listimage') {
            //        return '/c/UEHandler?actionType=' + action;
            //    } else {
            //        return this._bkGetActionUrl.call(this, action);
            //    }
            //}

            function toggleEmotionSelectorStatus(obj, clickObj) {
                if (obj.is(":hidden")) {
                    var $parentNode = clickObj.parent();
                    var position, top, left;

                    if ($parentNode.is('span') && $parentNode.parents('table.aui_dialog').length == 0) {
                        position = $parentNode.offset();
                        top = (position.top - 959);
                        left = position.left;
                    } else {
                        position = clickObj.offset();
                        top = position.top - 959;
                        left = position.left - 17;
                    }
                    if (isChrome) {
                        top = position.top - 994;
                    }
                    obj.attr("style", "display:block;position:relative;top:" + top + "px; left:" + left + "px;");
                    if ($('div[id=emotion-container]', obj).children('div[id=listEmotions-]').length <= 0) {
                        $("#emotion-tabs li:first").addClass("active");
                        $("#emotion-tabs li a:first", obj).one('click', function () {
                            bindEmotionTabClickEvent($(this));
                            return false;
                        }).click();
                    }
                } else {
                    obj.hide();

                }

                $(document).off("click").on("click", function (e) {
                    var $emotionTabs = $("#emotion-tabs *", $(this));
                    if ($(e.target).is($emotionTabs) || $(e.target).hasClass("edui-icon")) {
                        return;
                    }
                    $(document).off("click", arguments.callee);
                    obj.hide();
                });

                return obj;
            }

            $("#emotion-tabs a").on('click', function () {
                bindEmotionTabClickEvent($(this));
                return false;
            });

            function bindEmotionTabClickEvent(obj) {

                var $emotionTabs = obj.parents("#emotion-tabs");
                $("li", $emotionTabs).removeClass("active");
                obj.parent().addClass("active");

                var value = obj.attr("value");
                var $listEmotions = $("#listEmotions-" + value, $emotionTabs.siblings('#emotion-container'));


                if ($listEmotions.length > 0) {
                    $listEmotions.show();
                } else {

                    LoadEmotions($emotionTabs.siblings('#emotion-container'), value, obj.attr("ohref"));
                }
                $("div[id^='listEmotions-']:not(#listEmotions-" + value + ")", $("#emotion-container")).hide();
            }

            function toggleMediaContainerStatus(obj, clickObj) {
                if (obj.is(":hidden")) {
                    var $parentNode = clickObj.parent();
                    var position, top, left;

                    if ($parentNode.is('span') && $parentNode.parents('table.aui_dialog').length == 0) {
                        position = $parentNode.offset();
                        top = (position.top - 959);
                        left = position.left;
                    } else {
                        position = clickObj.offset();
                        top = position.top - 959;
                        left = position.left - 17;
                    }
                    if (isChrome) {
                        top = -915;
                    } else {
                        top = -880;
                    }
                    obj.attr("style", "display:block;position:relative;top:" + top + "px; left:" + left + "px;");
                } else {
                    obj.hide();
                }

                $(document).on("click", function (e) {
                    $(document).unbind("click", arguments.callee);
                    if ($(e.target).is($('*:not(.tn-smallicon-cross)', obj))) {
                        return;
                    }
                    obj.hide();
                });

                return obj;
            }

            $("textarea[plugin='ueditor']").livequery(function () {
                var $this = $(this);
                var id = $this.attr("id");
                var data;
                try {
                    var data = $.parseJSON($this.attr("data"));
                } catch (e) { /* noop */ }
                if (!data) data = {};
                var maximumWords = $this.attr("maximumWords");
                var educlass = $this.attr("class");
                //自定义样式
                var types = $this.attr("types");
                var tenant = $this.attr("tenant");
                var initialFrameHeight = $this.attr("initialFrameHeight");
                var initialFrameWidth = $this.attr("initialFrameWidth");
                var fileUploadUrl = $this.data('uploader-file-uploadurl');
                var imageUploadUrl = $this.data('uploader-image-uploadurl');
                var facePath = $this.data('face-path');
                var ownerid = $this.data('uploader-ownerid');
                var tenanttypeid = $this.data('uploader-tenanttypeid') || data.tenantTypeId;
                var associateid = $this.data('uploader-associateid') || data.associateId;
                var extensions = $this.data('uploader-extensions');
                var toolbarExt = $this.data('extensions') || ''; /*|| 'insertface,uploadfile,uploadimage';*/ // insertface,uploadfile,uploadimage
                var ue;

                //自定义组件 ,  'attachment'
                var alls = "['fullscreen','bold', 'italic', 'underline', 'strikethrough', 'forecolor', 'link', '|', 'fontfamily', 'fontsize', '|','justifyleft', 'justifycenter', 'justifyright', 'justifyjustify' ";
                //var allssm = "'insertvideo'";
                //if (tenant == 1) {
                //    alls = alls + allssm;
                //}
                var allsattachment = ",'|'";
                var allsmap = ",'|', 'map'";
                var allsvideo = ",'|','attachment', 'insertvideo'";
                var allsinsertcode = ",'|', 'insertcode'";
                var allend = "]";
                switch (types) {
                    case "allsattachment":
                        alls = alls + allsattachment;
                        break;
                    case "video":
                        alls = alls + allsvideo;
                        break;
                    case "map":
                        alls = alls + allsmap;
                        break;
                    case "insertcode":
                        alls = alls + allsinsertcode;
                        break;
                    case "map,insertcode":
                        alls = alls + allsmap + allsinsertcode;
                        break;
                    default:
                        break;
                }
                alls = alls + allend;

                alls = eval(alls);

                toolbarExt.indexOf('insertface') > -1 && registerInsertFace(id, facePath); // 插入表情按钮
                toolbarExt.indexOf('uploadfile') > -1 && registerUploadFile(id, fileUploadUrl); // 上传文件按钮
                toolbarExt.indexOf('uploadimage') > -1 && registerUploadImage(id, imageUploadUrl); // 上传图片按钮
                //重新加载编辑器
                UE.delEditor(id);
                window['ueditor#' + id + '.data'] = data;
                var ue = UE.getEditor(id, {
                    maximumWords: maximumWords,
                    toolbars: [alls],
                    catchRemoteImageEnable: false,
                    initialFrameWidth: initialFrameWidth,
                    initialFrameHeight: initialFrameHeight,
                    autoHeightEnabled: false,
                    imageActionName:imageUploadUrl,
                    tenantTypeId:tenanttypeid
                });
                ////自动保存
                //setTimeout(function () {
                //    ue.execCommand('drafts');
                //}, 500);
                //参数
                ue.addListener('fullscreenchanged', function (type, isFullScreen) {
                    $('#' + id + ' .edui-editor-iframeholder').css('height', isFullScreen ? '100%' : initialFrameHeight + 'px');
                })
                ue.ready(function () {
                    ue.execCommand('serverparam', data);
                });
            });

        });
    });
// function getRootPath() {
//     // 获取artDialog路径
//     var path = window['_ueditor_path'] || (function (script, i, me) {
//         for (i in script) {
//             // 如果通过第三方脚本加载器加载本文件，请保证文件名含有"artDialog"字符
//             if (script[i].src && script[i].src.indexOf('ueditor') !== -1) me = script[i];
//         };
//         _thisScript = me || script[script.length - 1];
//         me = _thisScript.src.replace(/\\/g, '/');
//         return me.lastIndexOf('/') < 0 ? '.' : me.substring(0, me.lastIndexOf('/'));
//     }(document.getElementsByTagName('script')));
//     if (path.indexOf("/Bundle") > 0)
//         path = path.substring(0, path.indexOf("/Bundle"));
//     else
//         path = path.substring(0, path.indexOf("/wwwroot/lib/ueditor"));
//     return path;

//     return (prePath + postPath);
// }

// function getUEBasePath(docUrl, confUrl) {

//     return getBasePath(docUrl || self.document.URL || self.location.href, confUrl || getConfigFilePath());

// }

// function getConfigFilePath() {

//     var configPath = document.getElementsByTagName('script');

//     return configPath[configPath.length - 1].src;

// }

// function getBasePath(docUrl, confUrl) {

//     var basePath = confUrl;


//     if (/^(\/|\\\\)/.test(confUrl)) {

//         basePath = /^.+?\w(\/|\\\\)/.exec(docUrl)[0] + confUrl.replace(/^(\/|\\\\)/, '');

//     } else if (!/^[a-z]+:/i.test(confUrl)) {

//         docUrl = docUrl.split("#")[0].split("?")[0].replace(/[^\\\/]+$/, '');

//         basePath = docUrl + "" + confUrl;

//     }

//     return optimizationPath(basePath);

// }

// function optimizationPath(path) {

//     var protocol = /^[a-z]+:\/\//.exec(path)[0],
//         tmp = null,
//         res = [];

//     path = path.replace(protocol, "").split("?")[0].split("#")[0];

//     path = path.replace(/\\/g, '/').split(/\//);

//     path[path.length - 1] = "";

//     while (path.length) {

//         if ((tmp = path.shift()) === "..") {
//             res.pop();
//         } else if (tmp !== ".") {
//             res.push(tmp);
//         }

//     }

//     return protocol + res.join("/");

// }


//window.UE = {
//    getUEBasePath: getUEBasePath, toolbars: [['bold', 'italic', 'underline', 'fontborder']]
//};