﻿<%@ Page Title="" Language="C#" MasterPageFile="./Main.Master" AutoEventWireup="true" CodeBehind="Setting.aspx.cs" Inherits="Jokul.Forum.Install.WebApp.Setting" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script type="text/javascript">
        $(function () {
            $("button[name='prev']").click(function () {
                window.location.href = "./check.aspx";
                $('button[name=\"prev\"]').button('loading');
                $('button[name=\"next\"]').addClass('disabled').attr("disabled", "disabled");
            });
            $("#main_form").ajaxForm({
                beforeSubmit: function (formData, jqForm, options) {
                    $('button[name=\"prev\"]').addClass('disabled').attr("disabled", "disabled");
                    $('button[name=\"next\"]').button('loading');
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        $.jokul.alert(data.description);
                        return;
                    }
                    window.location.href = "./wait.aspx";
                    $.jokul.wait("准备安装");
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                },
                complete: function () {
                    $('button[name=\"next\"]').button('reset');
                    $('button[name=\"previous\"]').removeClass('disabled').removeAttr("disabled", "disabled");
                },
                data: { act: "setting" },
                url: "./common.ashx",
                type: 'post',
                dataType: 'json'
            });

            $("input[name=\"passport_install\"]").change(function () {
                var control = $(this);
                if (!control.is(":checked"))
                    return;
                var val = parseInt(control.val());
                if (val <= 0) {
                    $(".logo_upload").show();
                    $(".logo_uploada").hide();
                }
                else {
                    $(".logo_upload").hide();
                    $(".logo_uploada").show();
                }
            }).change();
        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <form id="main_form" action="<%=HttpUtility.HtmlAttributeEncode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal">
        <div class="lic">
            <div class="page-header">
                <h1>Jokul Passport 环境配置</h1>
            </div>
            <div class="control-group">
                <label class="control-label">
                    数据库服务器
                </label>
                <div class="controls">
                    <label class="radio">
                        <input name="passport_install" type="radio" value="1"<%if(!HasLocalPassport){%> disabled="disabled"<%}%><%if(PassportInstall>0){ %> checked="checked"<%} %> />
                        未安装过 Jokul Passport
                    </label>
                    <label class="radio">
                        <input name="passport_install" type="radio" value="0"<%if(HasLocalPassport){%> disabled="disabled"<%}%><%if(PassportInstall<=0){ %> checked="checked"<%} %> />
                        挂接到已经存在的 Jokul Passport 中
                    </label>
                </div>
            </div>
            <div class="logo_upload" style="display:none;">
                <div class="control-group">
                    <label class="control-label">
                        接口URL
                    </label>
                    <div class="controls">
                        <input name="passport_url" type="text" value="<%=HttpUtility.HtmlAttributeEncode( PassportURL) %>" class="text" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        接口服务器IP
                    </label>
                    <div class="controls">
                        <input name="passport_ip" type="text" value="<%=HttpUtility.HtmlAttributeEncode( PassportIP) %>" class="text" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        创始人用户名
                    </label>
                    <div class="controls">
                        <input name="passport_username" type="text" value="<%=HttpUtility.HtmlAttributeEncode( PassportUsername) %>" class="text" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        创始人密码
                    </label>
                    <div class="controls">
                        <input name="passport_password" type="password" value="<%=HttpUtility.HtmlAttributeEncode( PassportPassword) %>" class="text" />
                    </div>
                </div>
            </div>
            
            <div class="page-header">
                <h1>Jokul Forum 数据配置</h1>
            </div>
            <div class="control-group">
                <label class="control-label">
                    数据库服务器
                </label>
                <div class="controls">
                    <input name="src_mssql_server" type="text" value="<%=HttpUtility.HtmlAttributeEncode( TargetMSSqlServer) %>" class="text" />
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">
                    数据库名称
                </label>
                <div class="controls">
                    <input name="src_mssql_db" type="text" value="<%=HttpUtility.HtmlAttributeEncode( TargetMSSqlDB) %>" class="text" />
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">
                    数据库用户名
                </label>
                <div class="controls">
                    <input name="src_mssql_username" type="text" value="<%=HttpUtility.HtmlAttributeEncode( TargetMSSqlUsername) %>" class="text" />
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">
                    数据库密码
                </label>
                <div class="controls">
                    <input name="src_mssql_password" type="password" value="<%=HttpUtility.HtmlAttributeEncode( TargetMSSqlPassword) %>" class="text" />
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">
                    数据表前缀
                </label>
                <div class="controls">
                    <input name="src_table_prefix" type="text" value="<%=HttpUtility.HtmlAttributeEncode( TargetMSSqlPrefix) %>" class="text" />
                </div>
            </div>
            <div class="control-group">
                <div class="controls">
                    <label class="checkbox">
                        <input name="src_mssql_create" type="checkbox" value="1"<%if(TargetMSSqlCreate>0){ %> checked="checked"<%} %> />
                        如果数据库不存在将自动创建
                    </label>
                </div>
            </div>
            <div class="logo_uploada" style="display:none;">
                <div class="page-header">
                    <h1>安装配置</h1>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        论坛管理员用户名
                    </label>
                    <div class="controls">
                        <input name="forum_username" type="text" value="<%=HttpUtility.HtmlAttributeEncode( ForumUsername) %>" class="text" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        论坛管理员密码
                    </label>
                    <div class="controls">
                        <input name="forum_password" type="password" value="<%=HttpUtility.HtmlAttributeEncode( ForumPassword) %>" class="text" />
                    </div>
                </div>
            </div>
        </div>
        <div class="form-actions">
            <button type="button" name="prev" class="btn" data-loading-text="请稍候...">上一步</button>
            <button type="submit" name="next" class="btn btn-primary" data-loading-text="请稍候...">下一步</button>
        </div>
    </form>
</asp:Content>
