﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Inside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Admin.Models.App_Update_Model>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    接入应用
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "run"); %>
    <%Html.SetString("menu.b", "application"); %>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        $(function () {
            $("#main_form").submit(function () {
                $('button[name=\"ok\"]').button('loading');
            });
            $("button[name='cancel']").click(function () {
                history.go(-1);
                return false;
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <%if(Html.HasValidationMessage()){ %>
    <div class="alert alert-error area">
    <%= Html.ValidationSummary(false)%>
    </div>
    <%} %>
    <div class="area area-form">
        <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
            <div class="control-group">
                <label class="control-label"><%=Html.LabelFor(m=>m.Name) %></label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.Name, new { @class = "text", size = "50" })%>
                <span class="help-block">
                    应用程序名称
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label"><%=Html.LabelFor(m=>m.Url) %></label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.Url, new { @class = "text", size = "100" })%>
                <span class="help-block">
                    此应用的对外公布地址
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">
                    <%=Html.LabelFor(m=>m.Icon) %>
                </label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.Icon, new { @class = "text",size="50"})%>
                <span class="help-block">
                    内容格式如：http://jokul.net/icon.jpg
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label"><%=Html.LabelFor(m => m.Description)%></label>
                <div class="controls">
                    <%=Html.TextAreaFor(m => m.Description, new { @class = "text",  rows="5",cols="100"})%>
                <span class="help-block">
                    对此应用的描述说明
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label"><%=Html.LabelFor(m=>m.Key) %></label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.Key, new { @class = "text", size = "50" })%>
                <span class="help-block">
                    应用的唯一标识
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label"><%=Html.LabelFor(m => m.SecurityCode)%></label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.SecurityCode, new { @class = "text", size = "50" })%>
                <span class="help-block">
                    应用通讯时所用到的通讯安全码
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">应用回调URL</label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.Api, new { @class = "text", size = "100" })%>
                <span class="help-block">
                    应用方的接收处理消息的接口地址<br />
                    如：http://jokul.net/client/api/passportclient.aspx
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">回调服务器IP</label>
                <div class="controls">
                    <%=Html.TextBoxFor(m => m.Ip, new { @class = "text", size = "100" })%>
                <span class="help-block">
                    回调地址所在的可访问的IP地址。
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">回调数据格式</label>
                <div class="controls">
                    <%=Html.DropDownListFor(m => m.Format, new SelectList(Model.Formats, "Value", "Name",Model.Format.ToString()),"请选择")%>
                <span class="help-block">
                    与应用回调接口通讯的通讯数据格式
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label">登录与登出</label>
                <div class="controls">
                    <label class="checkbox"><%=Html.CheckBoxFor(m=>m.AsyncNotify) %>开启登录与登出的异步通知方式</label>
                <span class="help-block">
                    当应用与Passport不在同一个域中可以使用此方式完成统一登录与登出。
                </span>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label"><%=Html.LabelFor(m => m.Show)%></label>
                <div class="controls">
                    <label class="checkbox"><%=Html.CheckBoxFor(m=>m.Show) %> 显示在前台</label>
                <span class="help-block">
                    是否显示在前台以便用户使用
                </span>
                </div>
            </div>
            <div class="control-group">
                <div class="controls">
                    <button type="submit" name="ok" value="save" id="Button_Login" class="btn btn-primary" data-loading-text="保存中...">保存</button>
                    <button type="button" name="cancel" value="cancel" class="btn">取消</button>
                </div>
            </div>
        </form>
    </div>







</asp:Content>
