﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Inside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Admin.Models.User_List_Model>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	用户管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "run"); %>
    <%Html.SetString("menu.b", "user"); %>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function page(p) {
            $("#form_page input[name='page']").val(p);
            $("#form_page").submit();
        }
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

        <form id="form_page" method="get" action="#">
            <%=Html.Hidden("act", "search")%>
            <%=Html.Hidden("page",Model.PageIndex) %>
            <%=Html.Hidden("user_id",Model.UserId) %>
            <%=Html.Hidden("username",Model.Username) %>
            <%=Html.Hidden("username_check",Model.UsernameCheck) %>
            <%=Html.Hidden("create_ip",Model.CreateIp) %>
            <%=Html.Hidden("last_ip",Model.LastIp) %>
            <%=Html.Hidden("create_email",Model.CreateEmail) %>
            <%=Html.Hidden("group_id",Model.GroupId) %>
        </form>
        <div id="div_search" class="panel panel-form area">
            <form id="form_search" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" class="form-horizontal form-jokul-horizontal">
                <div class="control-group">
                    <label class="control-label">
                        UID
                    </label>
                    <div class="controls">
                        <%=Html.TextBox("user_id",Model.UserId, new {@class="text",size="50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        帐号
                    </label>
                    <div class="controls">
                        <%=Html.TextBox("username",Model.Username, new { @class = "text", size = "50" })%>
                        <label class="checkbox inline">
                        <%=Html.CheckBox("username_check",Model.UsernameCheck)%>模糊
                            </label>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        注册IP
                    </label>
                    <div class="controls">
                        <%=Html.TextBox("create_ip",Model.CreateIp, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        登录IP
                    </label>
                    <div class="controls">
                        <%=Html.TextBox("last_ip",Model.LastIp, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        Email
                    </label>
                    <div class="controls">
                        <%=Html.TextBox("create_email",Model.CreateEmail, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        分组
                    </label>
                    <div class="controls">
                        <%=Html.DropDownList("group_id", new SelectList(Model.Groups, "Id", "Name",Model.GroupId), "未选择")%>
                    </div>

                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" value="Search" class="btn">查询</button>
                    </div>
                </div>

            </form>
        </div>
    
        <div class="area">
            <a href="<%=Url.Action("Update") %>" class="btn btn-primary">添加</a>
        </div>




        <div id="div_search_list" class="area">
            <form id="form_search_list" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th class="span1 center" style="width:50px;">头像
                            </th>
                            <th width="60" class="center">
                                Id
                            </th>
                            <th width="160" class="center">
                                名称
                            </th>
                            <th width="200" class="center">
                                Email
                            </th>
                            <th>
                                第三方登录
                            </th>
                            <th width="120" class="center">
                                组
                            </th>
                            <th width="80" class="center">
                                操作
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <%if (Model.Users.Any()){ %>
                            <%foreach (var user in Model.Users){ %>
                                <tr>
                                    <th class="center middle">
                                        <img src="<%=Url.Avatar50( user.Id) %>" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar/none_50.jpg")%>'" alt="头像" style="width:100%;" />
                                    </th>
                                    <td class="center middle"><%=user.Id %>
                                    </td>
                                    <td class="center middle"><%=user.Username %>
                                    </td>
                                    <td class="center middle">
                                        <%if (string.IsNullOrEmpty(user.Email)){ %>
                                            无
                                        <%}else{ %>
                                            <%=user.Email %>
                                        <%} %>
                                    </td>
                                    <td class="middle">
                                        <%if(user.OAuthBindItems.Any()){ %>
                                            <%for (var i = 0; i < user.OAuthBindItems.Length;i++ ){ %>
                                                <%if(i>0){ %>,<%} %>
                                                <%=user.OAuthBindItems[i].OAuthName %>
                                            <%} %>
                                        <%}else{ %>
                                            无
                                        <%} %>
                                    </td>
                                    <td class="center middle">
                                        <%=user.Group.Name %>
                                    </td>
                                    <td class="center middle">
                                        <%=Html.ActionLink("编辑", "Update", new { uid = user.Id }, null)%>
                                        |
                                        <a href="#" data-redirect="<%=Url.Action("Remove", new { id = user.Id })%>" data-act="delete" data-confirm-message="您确定要删除吗?">删除</a>
                                        
                                    </td>
                                </tr>
                            <%} %>
                        <%}else{ %>
                            <tr>
                                <td colspan="7">
                                    无用户数据
                                </td>
                            </tr>
                        <%} %>
                    </tbody>
                </table>
            </form>
        </div>
        <div class="pagination area">
            <%
            int tabPageSize=3;
            int pageIndex = (int)Model.PageIndex;
            int pageCount = (int)Model.PageCount;
            int tabPageMin=0;
            int tabPageMax=0;
    
            if (pageCount>tabPageSize*2+1)
            {
                if (pageIndex-tabPageSize>0)
                {
                    if (pageIndex+tabPageSize<pageCount)
                    {
                        tabPageMin = pageIndex-tabPageSize;
                        tabPageMax = tabPageMin+tabPageSize*2;
                    }
                    else
                    {
                        tabPageMin = pageCount-tabPageSize*2;
                        tabPageMax = pageCount;
                    }
                }
                else
                {
                    tabPageMin=1;
                    tabPageMax = tabPageSize*2+1;
                }
            }
            else
            {
                tabPageMin=1;
                tabPageMax=pageCount;
            }
            %>
            <ul>
                <li><a href="javascript:void(0);" onclick="page(1)">«</a></li>
            <%for (var i = tabPageMin; i <= tabPageMax; i++){ %>
                <%if (pageIndex == i){ %>
                <li class="active"><a href="#"><%=i %></a></li>
                <%}else{ %>
                <li><a href="javascript:void(0);" onclick="javascript:page(<%=i %>)"><%=i %></a></li>
                <%} %>
            <%} %>
                <li><a href="javascript:void(0);" onclick="javascript:page(<%=pageCount %>)">»</a></li>
            </ul>
        </div>

</asp:Content>
