﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Inside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Admin.Models.User_Update_Model>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	用户管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "run"); %>
    <%Html.SetString("menu.b", "user"); %>
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        $(document).ready(function () {
    
            $("select[name=\"group\"],input[name=\"group\"]").change(function(){
                var control=$(this);
                var type_value=$(":selected",control).attr("gt");

                $(".gt_ex").hide();
                switch(type_value)
                {
                    case "0":
                        $(".everyone").show();
                    break;
                    case "1":
                        $(".admin").show();
                        break;
                    case "2":
                        $(".user").show();
                        break;
                    case "3":
                        $(".gt_in").show();
                    break;
                    case "10":
                        $(".guest").show();
                    case "100":
                        $(".founder").show();
                    break;
                    default:
                        $(".null").show();
                    break;
                }
            }).change();
        
            $("#main_form").ajaxForm({
                beforeSubmit: function (formData, jqForm, options) {
                    $('button[name=\"ok\"]').button('loading');
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        $.jokul.alert(data.description);
                        $('button[name=\"ok\"]').button('reset');
                        return;
                    }
                    window.location.href="<%=Model.BackUrl %>";
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                    $('button[name=\"ok\"]').button('reset');
                },
                url: "<%=Url.Action("User_Update","Handler") %>",
                type: 'post',
                dataType: 'json'
            });
            
            $("button[name='cancel']").click(function(){
                history.go(-1);
                return false;
            });

            $("button[name='delete_avatar']").click(function(){
                var uid = $("input[name='uid']").val();

                $.ajax({
                    beforeSend: function () {
                        $('button[name=\"delete_avatar\"]').button('loading');
                    },
                    url: "<%=Url.Action("User_DeleteAvatar","Handler") %>",
                    type: 'get',
                    dataType: 'json',
                    async: true,
                    cache: false,
                    data: { uid: uid },
                    success: function (data, statusText) {
                        if (data.error) {
                            $.jokul.alert(data.description);
                            return;
                        }
                        var img_url = $("#avatar").attr("src");
                        $("#avatar").attr("src", img_url);
                    },
                    error: function () {
                        $.jokul.alert("服务器通讯失败");
                    },
                    complete: function () {
                        $('button[name=\"delete_avatar\"]').button('reset');
                    }
                });
            });
        });
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    
        <div class="area area-form">
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">

                <%= Html.ValidationSummary(false, null, new { @class="error" })%>
                <%=Html.Hidden("url",Model.BackUrl) %>
                <%=Html.Hidden("uid",Model.UserId)%>
                <%if (Model.UserId>0){ %>
                    <div class="control-group">
                        <label class="control-label">
                            UID
                        </label>
                        <div class="controls">
                            <%=Html.DisplayTextFor(m => m.UserId)%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            头像
                        </label>
                        <div class="controls">
                            <img id="avatar" src="<%=Url.Action("Avatar","Api",new{area="PassportHome",uid=Model.UserId}) %>" class="img-rounded" />
                        </div>
                    </div>
                    <div class="control-group">
                        <div class="controls">
                            <button name="delete_avatar" type="button" value="1" class="btn" data-loading-text="请稍候...">删除头像</button>
                        </div>
                    </div>
                <%} %>
                <div class="control-group">
                    <label class="control-label">
                        帐号
                    </label>
                    <div class="controls">
                        <%if (Model.UserId>0){ %>
                            <%=Html.DisplayTextFor(m => m.Username)%>
                            <%=Html.Hidden("username",Model.Username)%>
                        <%}else{ %>
                            <%=Html.TextBox("username",Model.Username, new { @class = "text", size = "20" })%>
                        <%} %>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        密码</label>
                    <div class="controls">
                        <%=Html.Password("password",Model.Password, new { @class = "text", size = "20",value=Model.Password })%>
                    <span class="help-block">
                        如果为空将不会更改密码
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        密保问题</label>
                    <div class="controls">
                        <%=Html.TextBox("question", Model.Question, new { @class = "text", size = "20" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        密保答案</label>
                    <div class="controls">
                        <%=Html.TextBox("answer", string.Empty, new { @class = "text", size = "20" })%>
                    <span class="help-block">
                        如果为空将不会更改
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        Email</label>
                    <div class="controls">
                        <%=Html.TextBox("email",Model.Email, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        组
                    </label>
                    <div class="controls">
                        <%if (Model.BaseEntity.Group.Type == (int)EGroupType.Founder){ %>
                            <%=Html.Hidden("group",Model.BaseEntity.GroupId) %>
                            <%=Model.BaseEntity.Group.Name %>
                        <%}else{ %>
                            <select name="group">
                                <option>请选择</option>
                                <%foreach(Jokul.Passport.Entities.GroupEntity g in Model.Groups){ %>
                                    <option value="<%=g.Id %>" gt="<%=g.Type %>"<%=Model.GroupId==g.Id?" selected=\"selected\"":"" %>><%=g.Name %></option>
                                <%} %>
                            </select>
                        <%} %>
                    </div>
                </div>
                <%if (Model.UserId>0){ %>
                    <div class="control-group">
                        <label class="control-label">
                            注册IP
                        </label>
                        <div class="controls">
                            <%=Html.DisplayFor(m => m.CreateIp)%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            注册时间
                        </label>
                        <div class="controls">
                            <%=Html.PassportTimeFromUtcTime(Model.CreateTime)%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            最后登录IP
                        </label>
                        <div class="controls">
                            <%=Html.DisplayTextFor(m => m.LastIp)%>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">
                            最后登录时间
                        </label>
                        <div class="controls">
                            <%=Html.PassportTimeFromUtcTime(Model.LastTime)%>
                        </div>
			        </div>
                <%} %>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候...">保存</button>
                        <button type="button" name="cancel" value="cancel" class="btn">取消</button>
                    </div>
                </div>
            </form>
        </div>




</asp:Content>