﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Home.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Home.Models.Auth_Login_Model>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	登录
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {
        function updateseccode() {
            var rand = Math.random();
            $('#VC').val('');
            $('#vcimg').attr("src","<%=Url.Action("ValidateCode", "Handler")%>?w=120&h=53&key=login&r="+rand);
        }
        updateseccode();
        $('#vcimg').click(function() {
            updateseccode();
            $('#VC').focus();
            return false;
        });

        $('#verifyshow').qtip({
            content: {
                attr: 'title'
            },
            position: {
                my: 'bottom center',
                at: 'top center',
                viewport: $(window),
                adjust: {
                    method: 'shift none'
                }
            },
            style: {
                classes: 'ui-tooltip-shadow ui-tooltip-blue'
            }
        })

        $(".input_txt").focus(function(){
            $(this).addClass("sf");
            $("label[for='"+$(this).attr("id")+"']").hide();
        }).blur(function(){
            $(this).removeClass("sf");
            if($(this).val())
                $("label[for='"+$(this).attr("id")+"']").hide();
            else
                $("label[for='"+$(this).attr("id")+"']").show();

        }).trigger("blur");


        $('#btn_register').click(function() {
            window.location.href='<%=Url.Action("Register") %>';
            return false;
        });

    });
</script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <%using (Html.BeginForm()){ %>
        <div class="login_panel">
            <div class="register">
                <h2>注册</h2>
                <p>您可以使用一个帐号登录本站提供的所有应用服务。</p>
                <button type="button" class="register_btn" tabindex="5" id="btn_register">立即注册</button>
            </div>
            <div class="login">
                <h2>登录</h2>
                <%= Html.ValidationSummary(false, string.Empty, new { @class = "error" })%>
                <div class="normal_login">
                    <ul class="login_list" id="web_login" style="display: block; ">
	                    <li class="login_input">
                            <span class="input_icon username_input_icon"></span>
		                    <label id="uhint" for="username" class="txt_default username_txt_default">支持 帐号/邮箱 登录</label>
                            <%= Html.TextBox("username", Model.Username, new { tabindex = "1", size = "40", @class = "input_txt username_input_txt" })%>
	                    </li>
	                    <li class="login_input">
                            <span class="input_icon password_input_icon"></span>
		                    <label id="phint" for="password" class="txt_default password_txt_default">登录密码</label>
                            <%= Html.Password("password", Model.Password, new { tabindex = "2", size = "40", value = Model.Password, @class = "input_txt password_input_txt" })%>
	                    </li>
	                    <li class="login_input yanzhengma">
		                    <span id="verifyinput"><label id="verifycodehint" for="vc" class="txt_default">请输入右侧验证码</label>
                            <%= Html.TextBox("vc", Model.VC, new { tabindex = "3", size = "20", style = @"text-transform:uppercase;", @class = "vc input_txt", value = string.Empty })%></span>
		                    <div class="yanzhengma_box" id="verifyshow" title="如果看不清，可以点击刷新。">
			                    <img class="yanzheng_img" id="vcimg" src="<%=ResolveUrl("../../images/loading.gif")%>">
		                    </div>
	                    </li>
	                    <li>
                            <div class="login_button">
                            <button type="submit" class="login_btn" tabindex="5" id="subbtn">登录</button>
                            </div>
                            <div class="login_enable">
                                <label title="为了确保您的信息安全，不建议在网吧等公共环境勾选此项"><%=Html.CheckBox("autologin",Model.AutoLogin) %>下次自动登录</label>
		                    </div>
                        </li>
                    </ul>
                    <%if(Model.OAuthList.Any()){ %>
                    <nav>
                        <%for(var i=0;i<Model.OAuthList.Length;i++){ %>
                            <%if(i>0){ %><span class="sep">|</span><%} %>
                            <a href="<%=Model.OAuthList[i].Url %>"><%=Model.OAuthList[i].Name %></a>
                        <%} %>
                    </nav>
                    <%} %>
                    <nav>
			            <%=Html.ActionLink("忘记密码", "ResetPassword")%>
                        <span class="sep">|</span>
			            <%=Html.ActionLink("注册帐号", "Register")%>
                        <%if (!string.IsNullOrEmpty(Model.ReturnUrl)){ %>
                            <span class="sep">|</span>
			                <a href="<%=Model.ReturnUrl %>">返回</a>
                        <%} %>
		            </nav>
                </div>
            </div>
            <div class="clearfix"></div>
        </div>
    <%} %>
</asp:Content>
