﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Home.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Home.Models.Home_Model>" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
	首页
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
<div class="main_panel">
    <div class="line_box">
        <div class="title">
            <h3>基本信息</h3>
        </div>
        <table cellpadding="0" cellspacing="20" border="0">
            <tbody>
                <tr>
                    <th>登录帐号</th>
                    <td>
                        <%=Model.Username%>
                    </td>
                </tr>
                <tr>
                    <th>安全信箱</th>
                    <td>
                        <%if (!StringHelper.IsNullOrWhiteSpace(Model.Email)) { %>
                            <%=Model.Email %>[<a href="<%=Url.Action("ChangeEmail","Setting") %>">更改绑定邮箱</a>]
                        <%}else{ %>
                            未设置
                            <div class="control">
                                您可以通过<a href="<%=Url.Action("ChangeEmail","Setting") %>">绑定邮箱</a>来找回账户密码以及可以用来登录账户
                            </div>
                        <%} %>
                    </td>
                </tr>
                <tr>
                    <th>最后登录</th>
                    <td><%=Model.LastTime.ToString("yyyy-MM-dd HH:mm:ss") %> (IP:<%=Model.LastIp %>)</td>
                </tr>
            </tbody>
        </table>
    </div>
    <%if (Model.BindList.Any()){ %>
    <div class="line_box spr">
        <div class="title">
            <h3>第三方绑定</h3>
        </div>
        <table cellpadding="0" cellspacing="20" border="0">
            <tbody>
                <%foreach(var bind in Model.BindList){ %>
                <tr id="Tr1">
                    <th><%=bind.Name %></th>
                    <td>
                        <%if(bind.Binded){ %>
                            已经成功绑定
                            [<a href="<%=Url.Action("UnBind", "OAuth", new {key=bind.Key })%>">解除绑定</a>]
                        <%}else{ %>
                            未绑定
                            [<a href="<%=Url.Action("Login", "OAuth", new {key=bind.Key, act="Bind" })%>">现在绑定</a>]
                        <%} %>
                    </td>
                </tr>
                <%} %>
            </tbody>
        </table>
    </div>
    <%} %>
    <div class="line_box spr">
        <div class="title">
            <h3>安全信息</h3>
        </div>
        <table cellpadding="0" cellspacing="20" border="0">
            <tbody>
                <tr id="bind_email">
                    <th>密码</th>
                    <td>
                        <%if(Model.Password){ %>
                        <%=Html.ActionLink("更改密码","ChangePassword","Setting") %>
                        <%}else{ %>
                            未设置，您可以<%=Html.ActionLink("现在设置","ChangePassword","Setting") %>。
                        <%} %>
                    </td>
                </tr>
                <tr id="bind_email">
                    <th>安全问答</th>
                    <td>
                        <%if(Model.Question){ %>
                            已经开启
                            [<%=Html.ActionLink("更换", "ChangeQA", "Setting")%>]
                        <%}else{ %>
                            未设置，您可以<%=Html.ActionLink("现在设置", "ChangeQA", "Setting")%>，以保护您的帐号安全。
                        <%} %>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <%if (Model.Apps.Count>0){ %>
        <div class="line_box spr">
            <div class="title">
                <h3>应用信息</h3>
            </div>
            <table cellpadding="0" cellspacing="20" border="0">
                <tbody>
                    <tr>
                        <th>应用服务</th>
                        <td>
                            <div class="app_list">
                                <ul>
                                    <%foreach (ApplicationEntity app in Model.Apps){ %>
                                    <li>
                                        <div class="title"><a href="<%=app.Url %>" target="_blank"><%=app.Name %></a></div>
                                        <div class="description"><%=app.Description %></div>
                                    </li>
                                    <%} %>
                                </ul>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    <%} %>
</div>
</asp:Content>
