﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<Jokul.Forum.Plugins.HomeT.HomtT_Setting_Model>" %>

<script type="text/javascript" src="<%=this.ResolveUrl ("../scripts/jsTree/jquery.jstree.js") %>"></script>
<script type="text/javascript" src="<%=this.ResolveUrl ("../scripts/jsTree/jquery.jstree.checkboxex.js") %>"></script>
<script type="text/javascript">
    $(function () {


        $("#board_tree")
        .bind("loaded.jstree", function () {
            var checkMenu = $("#main_form input[name='boards']").val();
            var array = checkMenu.split(",");
            for (var i = 0; i < array.length; i++) {
                if (array[i] == "")
                    continue;
                if ($("#" + array[i]).length <= 0)
                    continue;

                $("#board_tree").jstree("check_node", $("#" + array[i]));
            }
        })
        .jstree({
            "core": {
                animation: 0,
                html_titles: true,
                strings: { loading: "加载中..." }
            },
            "json_data": {
                ajax: {
                    async: true,
                    type: 'GET',
                    dataType: 'json',
                    url: "<%=Url.Action("Board_JsTreeSelect","Handler") %>",
			        //data : function (n) {
			        //    return { id : n.attr ? "jt_"+n.attr("id") : 0 }; 
			        //},
                    success: function (data, status, xhr) {
                        //alert(0);
                    },
                    error: function (xhr, status, exception) {
                        //alert(1);
                    }
			    }
		    },
            "themes": {
                "theme": "default",
                "dots": false,
                "icons": false
            },
            "plugins": ["themes", "json_data", "checkboxex"]

        });

        //取得选中的菜单id  
        function getJstree() {
            //取得所有选中的节点，返回节点对象的集合  
            var menu = $("#board_tree").jstree("get_checked");
            var ids = [];
            for (i = 0; i < menu.size() ; i++) {
                ids.push(menu[i].id);
            }
            var t = "," + ids + ",";
            $("#main_form input[name='boards']").val(t);
        }

        $("#main_form").submit(function () {
            getJstree();
            return true;
        });

        $("button[name='cancel']").click(function () {
            //history.go(-1);
            window.location.href = "<%=Html.AttributeEncode( Model.BackUrl) %>";
            return false;
        });
    });
</script>

<div class="area">

<form id="main_form" action="<%=Request.Url.AbsoluteUri %>" method="post" class="form-horizontal form-jokul-horizontal">
    
    <div class="area area-form">
        <div class="control-group">
            <label class="control-label">
                热门版块侧边栏
            </label>
            <div class="controls">
                <label class="checkbox"><input type="checkbox" value="1" name="board_side"<%if(Model.BoardSide){ %> checked="checked"<%} %> />在主题列表显示侧边热门版块栏</label>
                <span class="help-block">在主题列表左侧显示热门版块列表</span>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">
                选择指定版块内容
            </label>
            <div class="controls">
                <%=Html.Hidden("boards", Model.Boards)%>
                <div id="board_tree">loading...</div>
                <span class="help-block">当所有选择为空时，将使用全站的版块内容</span>
            </div>
        </div>
        <div class="control-group">
            <div class="controls">
                <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候..." disabled="disabled" data-cw="保存">加载中...</button>
                <button type="button" name="cancel" value="cancel" class="btn" >返回</button>
            </div>
        </div>
    </div>
</form>
</div>