﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminAdvertisement_List_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    广告管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "run"); %>
    <%Html.SetString("menu.b", "advertisement"); %>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <div class="area">
                <a href="<%=Url.Action( "Update", "Advertisement")%>" class="btn btn-primary">添加</a>
            </div>
            <div class="area">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th style="width:120px;" class="center">
                                    类别
                                </th>
                                <th style="width:60px;" class="center">
                                    序列
                                </th>
                                <th style="width:60px;" class="center">
                                    状态
                                </th>
                                <th>
                                    广告名称
                                </th>
                                <th style="width:120px;" class="center">
                                    操作
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <%if (Model.List.Count > 0)
                                { %>
                        <%foreach (var user in Model.List)
                            { %>
                            <tr>
                                <th class="center">
                                    <%=EnumHelper.GetEnumDescription<EAdvertisementType>(user.Type) %>
                                </th>
                                <td class="center">-
                                </td>
                                <td class="center"><%=user.AllowAvailable>0?"启用":"x" %>
                                </td>
                                <td><%=user.Name %>
                                </td>
                                <td class="center">
                                    <button type="button" class="btn btn-small" data-act="go" data-redirect="<%=Url.Action("Update", new { id = user.Id })%>">编辑</button>
                                    <button type="button" class="btn btn-small" data-act="delete" data-redirect="<%=Url.Action("Remove", new { id = user.Id })%>" data-confirm-message="您确定要删除吗?">删除</button>
                                </td>
                            </tr>
                        <%} %>
                            <%}
                                else
                                { %>
                            <tr>
                                <td colspan="2">
                                    无数据
                                </td>
                            </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>
</asp:Content>
