﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminBoard_UpdateModerator_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    版主管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "board"); %>
    <%Html.SetString("menu.b", "board"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">

    <script type="text/javascript">
        $(document).ready(function () {
        
            //提交
            var options = {
                beforeSubmit: function (formData, jqForm, options) {
                    $('button[name=\"moderator_add\"]').button('loading');
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        $.jokul.alert(data.description);
                        $('button[name=\"moderator_add\"]').button('reset');
                        return;
                    }
                    window.location.reload();
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                    $('button[name=\"moderator_add\"]').button('reset');
                },
                url: "<%=Url.Action("Board_ModeratorUpdate","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#main_form").ajaxForm(options);

            $("a.remove").click(function(){
                $.ajax({
                    url: '<%=Url.Action("Board_ModeratorDelete","Handler") %>',
                    type: 'POST',
                    dataType: 'json',
                    async: true,
                    cache: false,
                    data:"&bid=<%=Model.Entity.Id %>&uid="+$(this).data("uid"),
                    success: function (responseText) {
                        if (responseText.error)
                        {
                            $.jokul.alert(responseText.description);
                            return;
                        }
                            window.location.reload();
                    },
                    error:function(){
                        $.jokul.alert("服务器通讯失败.");
                    }
                });
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

                <div class="area">
                    <button type="button" name="cancel" value="cancel" data-redirect="<%=Url.Action("List","Board")%>" data-act="go" class="btn">返回</button>
                </div>
                <div class="area">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th style="width:120px;">
                                    版主
                                </th>
                                <th style="width:120px;">
                                    分组
                                </th>
                                <th style="width:60px">
                                    管理
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <%foreach (var moderator in Model.Moderators){ %>
                            <tr>
                                <td><%=moderator.Username %></td>
                                <td><%=moderator.GroupName %></td>
                                <td><a href="javascript:void(0);" class="remove" data-uid="<%=moderator.UserId %>">删除</a></td>
                            </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>
                <div class="area">
                    <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-inline">
                        <%=Html.Hidden("bid",Model.Entity.Id) %>
                        <%=Html.TextBox("moderator_add_username", string.Empty, new {@class="text", size = "20" })%>
                        <%=Html.DropDownList("moderator_add_group", new SelectList(Model.ModeratorGroups, "Id", "Name", ""), "请选择", null)%>
                        <button name="moderator_add" type="submit" value="add" class="btn btn-primary" data-loading-text="请稍候..." >添加</button>
                    </form>
                </div>
</asp:Content>
