﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminEmotion_SystemCategoryList_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    未安装的表情包
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "view"); %>
    <%Html.SetString("menu.b", "emotion"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {

        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    $('button[name=\"ok\"]').button('reset');
                    return;
                }
                window.location.href = "<%=Url.Action("CategoryList") %>";
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Emotion_CategoryInstall","Handler") %>",
            type: 'post',
            dataType: 'json'
        });

    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
                <div class="area">
                    <a href="<%=Url.Action( "CategoryList", "Emotion")%>" class="btn">返回表情分类</a>
                </div>
                <div class="area">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th style="width:40px;">
                                        选择
                                    </th>
                                    <th style="width:140px;">
                                        文件夹名
                                    </th>
                                    <th style="width:160px;">
                                        分类名称
                                    </th>
                                    <th>
                                        描述
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <%if (Model.List.Count > 0){ %>
                                <%var i=0; %>
                            <%foreach (var user in Model.List){ %>
                                <%i++; %>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="index" value="<%=i %>" /></td>
                                    <td>
                                        <input type="hidden" name="key_<%=i %>" value="<%=Html.Encode(user.Key) %>" />
                                        <%=user.Key %></td>
                                    <td><input type="text" name="name_<%=i %>" value="<%=Html.Encode(user.Name) %>" /></td>
                                    <td>
                                        <%=user.Description %>
                                    </td>
                                </tr>
                            <%} %>
                                <%}
                                    else
                                    { %>
                                <tr>
                                    <td colspan="4">
                                        无数据
                                    </td>
                                </tr>
                                <%} %>
                            </tbody>
                        </table>
                    </div>
                <div class="area">
                    <button name="ok" value="install" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="安装">请稍等...</button>
                </div>
            </form>
</asp:Content>
