﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminGroup_Update_Model>" %>
<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
            <%if (Model.Entity.Id > 0){ %>
                <%=Model.Entity.Name %> 分组编辑
            <%}else{ %>
                添加分组
            <%} %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "user"); %>
    <%Html.SetString("menu.b", "group"); %>
</asp:Content>
<asp:Content ContentPlaceHolderID="HeadStyle" runat="server">
    <link href="<%=this.ResolveUrl ("../../utility/colorpicker/css/colorpicker.css") %>" rel="stylesheet" type="text/css" />
    <style type="text/css">
            .ex{display:none;}
    </style>
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../utility/colorpicker/js/bootstrap-colorpicker.js") %>" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function () {

        $('#color').colorpicker();


        $('#tab a').click(function (e) {
            e.preventDefault();
            $(this).tab('show');
        })

        $("select[name=\"type\"],input[name=\"type\"]").change(function(){
            var control=$(this);
            var type_value=control.val();

            $(".ex").hide();
            switch(type_value)
            {
                case "0":
                    $(".everyone").show();
                break;
                case "1":
                    $(".admin").show();
                    break;
                case "2":
                    $(".super").show();
                    break;
                case "3":
                    $(".board").show();
                    break;
                case "4":
                    $(".guest").show();
                break;
                case "5":
                    $(".lv").show();
                break;
                case "6":
                    $(".sp").show();
                break;
                case "7":
                    $(".in").show();
                break;
                case "100":
                    $(".founder").show();
                break;
                default:
                    $(".null").show();
                break;
            }
        }).change();


        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    $('button[name=\"ok\"]').button('reset');
                    return;
                }
                window.location.href="<%=Url.Action("List") %>";
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Group_Update","Handler") %>",
            type: 'post',
            dataType: 'json'
        });
        $("button[name='cancel']").click(function(){
            history.go(-1);
            return false;
        });

    });
</script>

</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <div class="area">
            <ul id="tab" class="nav nav-tabs">
                <li class="active"><a href="#base_tab">基本设置</a></li>
                <li class="ex founder admin super board guest lv sp in"><a href="#gex">扩展设置</a></li>
                <li class="ex founder admin super board lv sp in"><a href="#rate">评分设置</a></li>
                <li class="ex admin super board guest lv sp in"><a href="#permission">前台使用权限</a></li>
                <li class="ex admin super board"><a href="#manage_permission">前台管理权限</a></li>
                <li class="ex admin"><a href="#admin_manage_permission">后台权限</a></li>
            </ul>
    </div>
            <%= Html.ValidationSummary(false, "出现如下问题：", new { @class = "error" })%>
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
        <div class="tab-content area area-form">
              <%=Html.Hidden("id", Model.Entity.Id)%>
            <div id="base_tab" class="tab-pane active">
                <div class="control-group">
                    <label class="control-label">
                        名称</label>
                    <div class="controls">
                        <%=Html.TextBox("name", Model.Entity.Name, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <%if (Model.Entity.Id > 0)
                  { %>
                    <%=Html.Hidden("type", Model.Entity.Type)%>
                <%}else{ %>
                    <div class="control-group">
                        <label class="control-label">
                            类型</label>
                        <div class="controls">
                            <select name="type">
                                <option value="-1">= 选择组 =</option>
                                <option value="1">管理员组</option>
                                <option value="2">超版组</option>
                                <option value="3">版主组</option>
                                <option value="5">升级用户组</option>
                                <option value="6">特殊用户组</option>
                            </select>
                        </div>
                    </div>
                <%} %>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        头衔颜色</label>
                    <div class="controls">



                        

                        <div id="color" class="input-append color" data-color="<%=Model.Entity.Color %>" data-color-format="hex">
  <input type="text" name="color" value="<%=Model.Entity.Color %>" />
  <span class="add-on"><i style="background-color: rgb(255, 146, 180)"></i></span>
</div>







                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        头衔图标</label>
                    <div class="controls">
                        <%=Html.TextBox("Image", Model.Entity.Image, new { @class = "text", size = "50" })%>
                        <span class="help-block">
                            如果使用“{论坛位置}/static/images/group/”中的文件可直接填写文件名（如：admin.gif）<br />
                            或使用绝对url地址（如：http://www.jokul.net/admin.gif）
                        </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        在线列表图标</label>
                    <div class="controls">
                        <%=Html.TextBox("OnlineImage", Model.Entity.OnlineImage, new { @class = "text", size = "50" })%>
                        <span class="help-block">
                            如果使用“{论坛位置}/static/images/online/”中的文件可直接填写文件名（如：admin.gif）<br />
                            或使用绝对url地址（如：http://www.jokul.net/admin.gif）
                        </span>
                    </div>
                </div>
                <div class="control-group ex lv">
                    <label class="control-label">
                        积分区间</label>
                    <div class="controls">
                        <%=Html.TextBox("CreditLower", Model.Entity.CreditLower, new { @class = "text input-small", size = "50" })%>
                        ~
                        <%=Html.TextBox("CreditHigher", Model.Entity.CreditHigher, new { @class = "text input-small", size = "50" })%>
                        <span class="help-block">
                            用户积分达到此值时会将此分组分配给用户使用<br />
                            注：当用户积分小于最小分组时，将分配起始分值最小的分组给用户使用<br />
                            如： 乞丐(-1分)、新手(0)、会员(100)，此时如果用户为-100积分将被分配使用“乞丐”组，此时如果用户为100积分将被分配使用“会员”组，此时如果用户为10积分将被分配使用“新手”组
                        </span>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候...">保存</button>
                        <button type="submit" name="cancel" value="cancel" class="btn">返回</button>
                    </div>
                </div>
            </div>
            <div id="gex" class="tab-pane">
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        显示ip段数</label>
                    <div class="controls">
                        <%=Html.TextBox("ViewIpField", Model.Extended.ViewIpField, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        日上传附件最大量</label>
                    <div class="controls">
                        <%=Html.TextBox("DayAttachmentSize", Model.Extended.DayAttachmentSize, new { @class = "text", size = "50" })%>
                        K(1024K=1M)
                        <span class="help-block">如果不限至当天上传附件量，单位为K，这里可以填0表示无限制。</span>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        附件扩展名</label>
                    <div class="controls">
                        <%=Html.TextBox("AttachmentExtension", Model.Extended.AttachmentExtension, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        发帖间隔时间</label>
                    <div class="controls">
                        <%=Html.TextBox("PostIntervalSecond", Model.Extended.PostIntervalSecond, new { @class = "text", size = "50" })%>
                        秒
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        使用搜索</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("search",0,Model.Extended.Search<=0) %>不可使用搜索</label>
                        <label class="radio"><%=Html.RadioButton("search",1,Model.Extended.Search>0) %>可以使用搜索</label>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        查看会员列表</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("member_list",0,Model.Extended.MemberList<=0) %>不可查看</label>
                        <label class="radio"><%=Html.RadioButton("member_list", 1, Model.Extended.MemberList > 0)%>可查看</label>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        发帖审核</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("post_check", (int)EGroupPostCheckType.None, Model.Extended.PostCheck == (int)EGroupPostCheckType.None) %>不需审核</label>
                        <label class="radio"><%=Html.RadioButton("post_check", (int)EGroupPostCheckType.All, Model.Extended.PostCheck == (int)EGroupPostCheckType.All)%>发主题与回复都需审核</label>
                        <label class="radio"><%=Html.RadioButton("post_check", (int)EGroupPostCheckType.Topic, Model.Extended.PostCheck == (int)EGroupPostCheckType.Topic)%>发主题需审核</label>
                        <label class="radio"><%=Html.RadioButton("post_check", (int)EGroupPostCheckType.Reply, Model.Extended.PostCheck == (int)EGroupPostCheckType.Reply)%>发回复需审核</label>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        出售附件</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("cost", 0, !Model.Extended.Cost)%>不可出售</label>
                        <label class="radio"><%=Html.RadioButton("cost",1,Model.Extended.Cost) %>可出售</label>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        出售上限</label>
                    <div class="controls">
                        <%=Html.TextBox("cost_max", Model.Extended.CostMax.ToString("0.##"), new { @class = "text", size = "5" })%>
                    </div>
                </div>
                <div class="control-group ex founder admin super board guest lv sp in">
                    <label class="control-label">
                        帖子编辑痕迹</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("post_update_log", 0, Model.Extended.PostUpdateLog==0)%>编辑帖子后不留下编辑痕迹</label>
                        <label class="radio"><%=Html.RadioButton("post_update_log",1,Model.Extended.PostUpdateLog==1) %>编辑帖子后留下编辑痕迹</label>
                        <label class="radio"><%=Html.RadioButton("post_update_log",2,Model.Extended.PostUpdateLog==2) %>让编辑者选择是否留下编辑痕迹</label>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候...">保存</button>
                        <button type="submit" name="cancel" value="cancel" class="btn">返回</button>
                    </div>
                </div>
            </div>
            <div id="rate" class="tab-pane">
                <div class="control-group ex founder admin super board lv sp in clearfix">
                    <div class="fl">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>选择</th>
                                    <th>名称</th>
                                    <th>最小值</th>
                                    <th>最大值</th>
                                </tr>
                            </thead>
                            <tbody>
                            <%
                            for (int i = 0; i < Model.Es.Length;i++ ){
                                    if (!Model.Es[i].Enable)
                                        continue;
                            %>
                                <tr>
                                    <td><%=Html.CheckBox("rate_"+Model.Rate[i].PointId,Model.Rate[i].Inherit>0) %></td>
                                    <td><%=Model.Es[i].Name%></td>
                                    <td><%=Html.TextBox("rate_" + Model.Rate[i].PointId + "_min", Model.Rate[i].MinValue.ToString("0.####"), new { @class = "input-mini text" })%></td>
                                    <td><%=Html.TextBox("rate_" + Model.Rate[i].PointId + "_max", Model.Rate[i].MaxValue.ToString("0.####"), new { @class = "input-mini text" })%></td>
                                </tr>
                            <%} %>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="control-group">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候...">保存</button>
                        <button type="submit" name="cancel" value="cancel" class="btn">返回</button>
                </div>
            </div>
            <div id="permission" class="tab-pane">
                <div class="control-group ex admin super board guest lv sp in">
                    <label class="control-label">
                        访问版块</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_visit_board", 1, Model.Permission.VisitBoard > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_visit_board", -1, !(Model.Permission.VisitBoard > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board guest lv sp in">
                    <label class="control-label">
                        访问主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_visit_topic", 1, Model.Permission.VisitTopic>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_visit_topic", -1, !(Model.Permission.VisitTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board guest lv sp in">
                    <label class="control-label">
                        发主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_post_topic", 1, Model.Permission.PostTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_post_topic", -1, !(Model.Permission.PostTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board guest lv sp in">
                    <label class="control-label">
                        发回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_post_reply", 1, Model.Permission.PostReply>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_post_reply", -1, !(Model.Permission.PostReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board guest lv sp in">
                    <label class="control-label">
                        上传附件</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_upload_attachment", 1, Model.Permission.UploadAttachment > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_upload_attachment", -1, !(Model.Permission.UploadAttachment > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board guest lv sp in">
                    <label class="control-label">
                        下载附件</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_view_attachment", 1, Model.Permission.ViewAttachment>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_view_attachment", -1, !(Model.Permission.ViewAttachment > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        编辑自己主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_update_myself_topic", 1, Model.Permission.UpdateMyselfTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_update_myself_topic", -1, !(Model.Permission.UpdateMyselfTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        编辑自己回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_update_myself_reply", 1, Model.Permission.UpdateMyselfReply>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_update_myself_reply", -1, !(Model.Permission.UpdateMyselfReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        删除自己主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_delete_myself_topic", 1, Model.Permission.DeleteMyselfTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_delete_myself_topic", -1, !(Model.Permission.DeleteMyselfTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        删除自己回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_delete_myself_reply", 1, Model.Permission.DeleteMyselfReply>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_delete_myself_reply", -1, !(Model.Permission.DeleteMyselfReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        直接查看隐藏主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_view_ban_topic", 1, Model.Permission.ViewBanTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_view_ban_topic", -1, !(Model.Permission.ViewBanTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        可以发表隐藏主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_post_ban_topic", 1, Model.Permission.PostBanTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_post_ban_topic", -1, !(Model.Permission.PostBanTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        主题评分</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_rate_topic", 1, Model.Permission.RateTopic>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_rate_topic", -1, !(Model.Permission.RateTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board lv sp in">
                    <label class="control-label">
                        回复评分</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("permission_rate_reply", 1, Model.Permission.RateReply>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("permission_rate_reply", -1, !(Model.Permission.RateReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候...">保存</button>
                        <button type="submit" name="cancel" value="cancel" class="btn">返回</button>
                    </div>
                </div>
            </div>
            <div id="manage_permission" class="tab-pane">
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        编辑主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_update_topic", 1, Model.ManagePermission.UpdateTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_update_topic", -1, !(Model.ManagePermission.UpdateTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        编辑回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_update_reply", 1, Model.ManagePermission.UpdateReply > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_update_reply", -1, !(Model.ManagePermission.UpdateReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        删除主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_delete_topic", 1, Model.ManagePermission.DeleteTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_delete_topic", -1, !(Model.ManagePermission.DeleteTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        删除回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_delete_reply", 1, Model.ManagePermission.DeleteReply > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_delete_reply", -1, !(Model.ManagePermission.DeleteReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        置顶主题<br />(本版)</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_top_topic_1", 1, Model.ManagePermission.TopTopic_1 > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_top_topic_1", -1, !(Model.ManagePermission.TopTopic_1 > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        置顶主题<br />(包括子版)</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_top_topic_2", 1, Model.ManagePermission.TopTopic_2 > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_top_topic_2", -1, !(Model.ManagePermission.TopTopic_2 > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        置顶主题<br />(全站)</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_top_topic_3", 1, Model.ManagePermission.TopTopic_3 > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_top_topic_3", -1, !(Model.ManagePermission.TopTopic_3 > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        审核主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_audit_topic", 1, Model.ManagePermission.AuditTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_audit_topic", -1, !(Model.ManagePermission.AuditTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        审核回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_audit_reply", 1, Model.ManagePermission.AuditReply > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_audit_reply", -1, !(Model.ManagePermission.AuditReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        精华主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_digest_topic", 1, Model.ManagePermission.DigestTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_digest_topic", -1, !(Model.ManagePermission.DigestTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        屏蔽主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_ban_topic", 1, Model.ManagePermission.BanTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_ban_topic", -1, !(Model.ManagePermission.BanTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        屏蔽回复</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_ban_reply", 1, Model.ManagePermission.BanReply > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_ban_reply", -1, !(Model.ManagePermission.BanReply > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        高亮主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_highlight_topic", 1, Model.ManagePermission.HighLightTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_highlight_topic", -1, !(Model.ManagePermission.HighLightTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        关闭主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_close_topic", 1, Model.ManagePermission.CloseTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_close_topic", -1, !(Model.ManagePermission.CloseTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        移动主题</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_move_topic", 1, Model.ManagePermission.MoveTopic > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_move_topic", -1, !(Model.ManagePermission.MoveTopic > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin super board">
                    <label class="control-label">
                        取消评分</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("manage_permission_Destruction_Rate_Post", 1, Model.ManagePermission.DestructionRatePost > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("manage_permission_Destruction_Rate_Post", -1, !(Model.ManagePermission.DestructionRatePost > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候...">保存</button>
                        <button type="submit" name="cancel" value="cancel" class="btn">返回</button>
                    </div>
                </div>
            </div>
            <div id="admin_manage_permission" class="tab-pane">
                <div class="control-group ex admin">
                    <label class="control-label">
                        友连管理</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("admin_manage_permission_link", 1, Model.AdminPermission.Link>0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("admin_manage_permission_link", -1, !(Model.AdminPermission.Link > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group ex admin">
                    <label class="control-label">
                        导航管理</label>
                    <div class="controls">
                    <label class="radio"><%=Html.RadioButton("admin_manage_permission_nav", 1, Model.AdminPermission.Nav > 0)%>允许</label>
                    <label class="radio"><%=Html.RadioButton("admin_manage_permission_nav", -1, !(Model.AdminPermission.Nav > 0))%>不允许</label>
                            </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" class="btn btn-primary" data-loading-text="请稍候..." disabled="disabled" data-cw="保存">加载中...</button>
                        <button type="submit" name="cancel" value="cancel" class="btn">返回</button>
                    </div>
                </div>
            </div>
        </div>
            </form>
</asp:Content>
