﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.Plugin_List_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    插件管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "view"); %>
    <%Html.SetString("menu.b", "plugin"); %>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <div class="area">
                <a href="<%=Url.Action("SystemList", "Plugin")%>" class="btn btn-primary">查找新插件</a>
            </div>
    <%if (Model.Items.Length > 0){ %>
        <div class="alert area">
            当插件运行时插件的文件会被占用无法删除与替换，如果您希望替换插件文件，请先“停用”插件再替换新的插件文件。
        </div>
                <div class="area">
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width:80px;">
                                    预览
                                </th>
                                <th>
                                    插件
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                                <%foreach (var user in Model.Items){ %>
                                    <tr>
                                        <td>
                        <a class="pull-left thumbnail" href="#">
                            <img src="<%=ResolveUrl("../../../../plugins/"+user.Key+"/preview.jpg") %>" alt="预览" style="width:64px;height:64px;" />
                        </a>
                                        </td>
                                        <td>
                                            <h4>
                                            <%=user.Name %>（<%=user.Key %> <%=user.Version %>）
                                            </h4>
                                            <%if (user.State==1){ %>
                                                <span class="label label-important">不适用于当前系统</span>
                                            <%} %>
                                            <%if (user.State==2){ %>
                                                <span class="label label-warning">需升级操作</span>
                                            <%} %>
                                            <%if (user.State==3){ %>
                                                <span class="label label-info"><%=user.StateDescription %></span>
                                            <%} %>
                                            <%if(!string.IsNullOrEmpty(user.Description)){ %>
                                                <div class="sp"><%=user.Description %></div>
                                            <%} %>
                                            <div class="btn-toolbar">
                                                <%switch (user.State){ %>
                                                <%case 1: %>
                                                <a href="<%=Url.Action( "Find", new { key = user.Key })%>" class="btn btn-warning">查找</a>
                                                <%break; %>
                                                <%case 2: %>
                                                <a href="<%=Url.Action( "Upgrade", new { key = user.Key })%>" class="btn btn-warning">升级</a>
                                                <%break; %>
                                                <%case 3: %>
                                                <%break; %>
                                                <%default: %>
                                                    <a href="<%=Url.Action( "Update", new { id = user.Id })%>" class="btn">设置</a>
                                                    <%if (user.Menus.Count>0){ %>
                                                        <div class="btn-group">
                                                            <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">管理<span class="caret"></span></a>
                                                            <ul class="dropdown-menu">
                                                                <%foreach (var nv in user.Menus.AllKeys){ %>
                                                                    <li><a href="<%=Html.AttributeEncode(user.Menus[nv])%>"><%=nv%></a></li>
                                                                <%} %>
                                                            </ul>
                                                        </div>
                                                    <%} %>
                                                <%break; %>
                                                <%} %>
                                                <a href="#" data-redirect="<%=Url.Action( "Uninstall", new { key = user.Key })%>" data-act="delete" data-confirm-message="请注意：删除插件将会引发服务重新启动，您确定要立即删除吗？" class="btn">卸载</a>
                                            </div>
                                        </td>
                                    </tr>
                                <%} %>
                        </tbody>
                    </table>
                </div>
                            <%}else{ %>
                                    <div class="alert area">
                                        还未使用任何插件
                                    </div>
                            <%} %>

</asp:Content>
