﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminSetting_Base_Model>" %>
<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
<%=Html.Lang("admin.setting.base.title") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "setting"); %>
    <%Html.SetString("menu.b", "setting.base"); %>
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">

    <script src="<%=this.ResolveUrl ("../../scripts/ckeditor/ckeditor.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.swfupload/swfupload.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
        
            var editor = CKEDITOR.replace('FooterCode', {
                toolbar: [
                    ['Source'], ['Bold', 'Italic', '-', 'NumberedList', 'BulletedList', '-', 'Link', 'Unlink', '-', 'Table', 'Image', 'Flash'], ['UIColor']
                ],
                startupMode: 'source',
                resize_enabled: false,
                removePlugins: 'elementspath',
                allowedContent: true,
                ignoreEmptyParagraph: true,
                enterMode: CKEDITOR.ENTER_BR
            });

            var swfu = new SWFUpload({
                file_post_name: "file",
                upload_url: "<%=Url.Action("Main_Logo_Upload","Handler") %>",
                flash_url: "<%=ResolveUrl ("../../scripts/jquery.swfupload/flash/swfupload.swf") %>",
                post_params: { "upload_sign": "<%=Model.UploadSign %>" },
                file_types: "*.jpg;*.gif;*.png",
                file_types_description: "Allowed Files",
                file_size_limit: 0,
                file_upload_limit: 0,
                file_queue_limit: 1,

                button_image_url: "<%=this.ResolveUrl ("../../scripts/jquery.swfupload/image/swfupload_button.png") %>",
			    button_width: "86",
			    button_height: "30",
			    button_placeholder_id: "spanSWFUploadButton",
			    button_cursor: SWFUpload.CURSOR.HAND,
			    button_action: SWFUpload.BUTTON_ACTION.SELECT_FILE,
			    button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,

			    minimum_flash_version: "9.0.28",
			    swfupload_load_failed_handler: function () {
			        var bt = $("#spanSWFUploadButton");
			        bt.empty();
			        bt.append("您当前所使用的浏览器，无法进行附件上传。");
			    },
			    file_dialog_complete_handler: function (numFilesSelected, numFilesQueued) {
			        if (numFilesSelected <= 0) return;
			        this.startUpload();
			    },
			    upload_start_handler: function (file) {
			        //wait
			    },
			    upload_success_handler: function (file, serverData) {
			        var v = JSON.parse(serverData);
			        if (v.error) {
			            $.jokul.alert(v.description);
			            return;
			        }

			        $("#logo_img").attr("src", "<%=Url.Action("Logo", "Api", new { area = "ForumHome",n=1,x=DateTime.Now.Ticks })%>&_=" + new Date().getTime());
                    //ok
			    },
			    upload_error_handler: function (file, errorCode, message) {
			        var description = "未知错误:" + errorCode;
			        switch (errorCode) {
			            case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
			                description="上传错误:" + message;
			                break;
			            case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
			                description="上传失败.";
			                break;
			            case SWFUpload.UPLOAD_ERROR.IO_ERROR:
			                description="服务器(IO)错误";
			                break;
			            case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
			                description="安全信息错误";
			                break;
			            case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
			                description="超出上传限制.";
			                break;
			            case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
			                description="验证失败.";
			                break;
			            case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
			                description = "取消";
			                break;
			            case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
			                description="上传已经停止";
			                break;
			        }
			        $.jokul.alert(description);
			    },
			    file_queue_error_handler: function (file, errorCode, message) {
			        var description = "未知错误(" + errorCode + "):" + message;
			        switch (errorCode) {
			            case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
			                description="同时进行上传的文件不能过多.";
			                break;
			            case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
			                description="文件过大.";
			                break;
			            case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
			                description="不能上传 0 字节文件.";
			                break;
			            case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
			                description="不支持的文件类型.";
			                break;
			        }
			        $.jokul.alert(description);
			    }
            });

            //提交
            $("#main_form").ajaxForm({
                beforeSerialize: function ($form, options) {
                    for (instance in CKEDITOR.instances)
                        CKEDITOR.instances[instance].updateElement();
                },
                beforeSubmit: function(formData, jqForm, options) {
                    $('button[name=\"ok\"]').button('loading');
                    return true;
                },
                success: function(data, statusText) {
                    if (data.error){
                        $.jokul.alert(data.description);
                        return;
                    }
                    $.jokul.alert("保存成功");
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                },
                complete: function () {
                    $('button[name=\"ok\"]').button('reset');
                },
                url: "<%=Url.Action("Setting_Base_Update","Handler") %>",
                type: 'post',
                dataType: 'json'
            });

            $("input[name=\"logo\"]").change(function () {
                var control = $(this);
                if (!control.is(":checked"))
                    return;
                var val = parseInt(control.val());
                if (val > 0)
                    $(".logo_upload").show();
                else
                    $(".logo_upload").hide();
            }).change();
        });
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

        <div class="area area-form">
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
                <div class="control-group">
                    <label class="control-label"><%=Html.Lang("admin.setting.base.forum_name") %></label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.AppName, new { @class = "text", size = "50" })%>
                        <span class="help-block"><%=Html.Lang("admin.setting.base.forum_name.description") %></span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label"><%=Html.Lang("admin.setting.base.logo") %></label>
                    <div class="controls">
                        <label class="radio"><input type="radio" value="0" name="logo"<%=Model.Logo<=0?" checked=\"checked\"":string.Empty %> /><%=Html.Lang("admin.setting.base.logo.skin") %></label>
                        <label class="radio"><input type="radio" value="2" name="logo"<%=Model.Logo>0?" checked=\"checked\"":string.Empty %> /><%=Html.Lang("admin.setting.base.logo.custom") %></label>
                        
                        <span class="help-block"><%=Html.Lang("admin.setting.base.logo.description") %></span>
                    </div>
                </div>
                <div class="control-group logo_upload" style="display:none;">
                    <div class="controls">
                        <img id="logo_img" src="<%=Url.Action("Logo", "Api", new { area = "ForumHome" })%>" alt="logo" />
                        <br />
                        <span id="spanSWFUploadButton">上传LOGO</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.Lang("admin.setting.base.icp") %>
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.ICP, new { @class = "text", size = "50" })%>
                    <span class="help-block">
                        <%=Html.Lang("admin.setting.base.icp.description") %>
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label"><%=Html.Lang("admin.setting.base.debug") %></label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButtonFor(m=>m.Debug,0) %>不显示</label>
                        <label class="radio"><%=Html.RadioButtonFor(m => m.Debug, 1)%>显示</label>
                    <span class="help-block"><%=Html.Lang("admin.setting.base.debug.description") %></span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        手机版支持</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("mobile",0,!Model.Mobile) %>不启用</label>
                        <label class="radio"><%=Html.RadioButton("mobile",1,Model.Mobile)%>启用</label>
                    <span class="help-block">
                        手机版可浏览简化的界面</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        客户端缓存</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButtonFor(m => m.NoCacheHeader, 0)%>启用</label>
                        <label class="radio"><%=Html.RadioButtonFor(m => m.NoCacheHeader, 1)%>不启用</label>
                    <span class="help-block">
                        浏览器缓存</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">GZip</label>
                    <div class="controls">
                        <label class="radio"><%=Html.RadioButton("gzip",1,Model.GZip)%>启用</label>
                        <label class="radio"><%=Html.RadioButton("gzip",0,!Model.GZip)%>不启用</label>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="email">
                        公开信箱</label>
                    <div class="controls">
                        <input id="email" name="email" type="email" class="text" value="<%=Html.Encode(Model.Email) %>" />
                    <span class="help-block">
                        用于显示在论坛最下方，可以方便管理员与用户更好的联系。</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        时区</label>
                    <div class="controls">
                        <%=Html.DropDownListFor(m => m.TimeZone, new SelectList(Model.TimeZones, "Id", "DisplayName"))%>
                    <span class="help-block">
                        可以选择当您的论坛运行时以哪个时区为准，默认为: GMT +08:00 北京</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        语言</label>
                    <div class="controls">
                        <%=Html.DropDownListFor(m => m.Lang, new SelectList(Model.Langs, "Name", "Title"), "默认", null)%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        皮肤</label>
                    <div class="controls">
                        <%=Html.DropDownListFor(m => m.Skin, new SelectList(Model.Skins, "Id", "Name"))%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        页脚代码</label>
                    <div class="controls">
                        <%=Html.TextAreaFor(m => m.FooterCode, new { @class = "text editor", rows = "5", cols = "100" })%>
                    <span class="help-block">
                        在这里可以将您在第三方网站申请到的统计代码复制进去或其它用途。
                    </span>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" name="ok" value="save" id="Button_Login" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="保存">加载中...</button>
                    </div>
                </div>
            </form>
        </div>
</asp:Content>
