﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminSetting_Safe_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
安全设置
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "setting"); %>
    <%Html.SetString("menu.b", "setting.safe"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">

<script type="text/javascript">
    $(document).ready(function () {

        $("input[name=\"link_filter\"]").change(function () {
            var control = $(this);
            if (!control.is(":checked"))
                return;
            var val = parseInt(control.val());
            if (val > 0)
                $(".link_url").show();
            else
                $(".link_url").hide();
        }).change();
        //提交
        {
            var options = {
                beforeSubmit: function (formData, jqForm, options) {
                    $('button[name=\"ok\"]').button('loading');
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        $.jokul.alert(data.description);
                        return;
                    }
                    $.jokul.alert("保存成功");
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                },
                complete: function () {
                    $('button[name=\"ok\"]').button('reset');
                },
                url: "<%=Url.Action("Setting_SafeUpdate","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#main_form").ajaxForm(options);
        }
    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">


        
<div class="area area-form">
<form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
        <div class="control-group">
            <label class="control-label">
                内容外链过滤
            </label>
            <div class="controls">
                <label class="radio"><%=Html.RadioButton("link_filter",0,Model.LinkFilter==0) %>关闭</label>
                <label class="radio"><%=Html.RadioButton("link_filter", 1,Model.LinkFilter==1)%>指定不提示的外链</label>
                <label class="radio"><%=Html.RadioButton("link_filter", 2,Model.LinkFilter==2)%>指定提示的外链</label>
            <span class="help-block">
                所有设置都不会影响当前应用所在域(<%=Request.Url.Host %>)
            </span>
            </div>
        </div>
    <div class="control-group link_url">
            <label class="control-label">
                内容外链过滤设置
            </label>
        <div class="controls">
                <%=Html.TextArea("links",Model.Links, new { @class = "text", cols = "100",rows="5" })%>
            <span class="help-block">
                格式为域名或IP，如：www.jokul.net或127.0.0.1
            </span>
            </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            帖子编辑超时限制
        </label>
        <div class="controls">
            <%=Html.TextBoxFor(m => m.PostEditTimeOut, new { @class = "input-mini text", size = "10" })%>&nbsp;分钟
        <span class="help-block">
	当前发帖人对帖子编辑时间的限制，即超过（单位：分钟）时间，该帖将无法编辑。<br />
注：管理人员不受此功能限制，若填0则为不限制。

        </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            帖子删除超时限制
        </label>
        <div class="controls">
            <%=Html.TextBoxFor(m => m.PostDeleteTimeOut, new { @class = "input-mini text", size = "10" })%>&nbsp;分钟
        <span class="help-block">
	当前发帖人对帖子删除时间的限制，即超过（单位：分钟）时间，该帖将无法删除。<br />
注：管理人员不受此功能限制，若填0则为不限制。

        </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            验证码
        </label>
        <div class="controls">
            <label class="checkbox">
                <%=Html.CheckBox("RegisterValidateCode", Model.RegisterValidateCode > 0)%>
                注册验证码
            </label>
            <label class="checkbox">
                <%=Html.CheckBox("LoginValidateCode", Model.LoginValidateCode > 0)%>
                登录验证码
            </label>
            <label class="checkbox">
                <%=Html.CheckBox("PostTopicValidateCode", Model.PostTopicValidateCode > 0)%>
                发主题验证码
            </label>
            <label class="checkbox">
                <%=Html.CheckBox("PostReplyValidateCode", Model.PostReplyValidateCode > 0)%>
                发回复验证码
            </label>
        <span class="help-block">
	        防止机器人
        </span>
        </div>
    </div>
    <div class="control-group">
    <div class="controls">
        <button type="submit" name="ok" value="save" id="Button_Login" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="保存">加载中...</button>
    </div>
    </div>
    </form>
</div>




</asp:Content>
