﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminUser_OnlineList_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    在线用户
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "user"); %>
    <%Html.SetString("menu.b", "user.online"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function on_page(p) {
            $("#form_page input[name='page']").val(p);
            $("#form_page").submit();
        }
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
    
        <div class="alert area">
            共 <%=Model.OnlineState.All %> 位用户在线,其中 <%=Model.OnlineState.User %> 位用户(隐身 <%=Model.OnlineState.NS %> 位),游客 <%=Model.OnlineState.All-Model.OnlineState.User %> 位.
        </div>
        <form id="form_page" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <%=Html.Hidden("page",Model.PageIndex) %>
        </form>
        <form id="form_search_list" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <div class="area">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th width="40">
                                头像
                            </th>
                            <th width="60">
                                UID
                            </th>
                            <th width="160">
                                帐号
                            </th>
                            <th width="160">
                                IP
                            </th>
                            <th>
                                最后
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <%if (Model.List.Count > 0){ %>
                            <%foreach (var user in Model.List){ %>
                                <tr>
                                    <th>
                                        <img src="<%=Url.Avatar50( user.UserId) %>" width="32"  onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar/none_50.jpg")%>'" />
                                    </th>
                                    <th>
                                        <%=user.UserId%>
                                    </th>
                                    <td>
                                        <%if (!string.IsNullOrEmpty(user.Image)){ %>
                                            <img src="<%=user.Image.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?user.Image: ResolveUrl("../../../../static/images/online/" + user.Image)%>" alt="group" />
                                        <%} %>
                                        <%=user.Username%>
                                    </td>
                                    <td>
                                        <%=user.IP%>
                                    </td>
                                    <td>
                                        <%=user.Description %>
                                    </td>
                                </tr>
                            <%} %>
                        <%}else{ %>
                            <tr>
                                <td colspan="5">
                                    无相关数据
                                </td>
                            </tr>
                        <%} %>
                    </tbody>
                </table>
            </div>
        </form>
        <div class="pagination area">
            <%
            int tabPageSize=3;
            int pageIndex = (int)Model.PageIndex;
            int pageCount = (int)Model.PageCount;
            int tabPageMin=0;
            int tabPageMax=0;
    
            if (pageCount>tabPageSize*2+1)
            {
                if (pageIndex-tabPageSize>0)
                {
                    if (pageIndex+tabPageSize<pageCount)
                    {
                        tabPageMin = pageIndex-tabPageSize;
                        tabPageMax = tabPageMin+tabPageSize*2;
                    }
                    else
                    {
                        tabPageMin = pageCount-tabPageSize*2;
                        tabPageMax = pageCount;
                    }
                }
                else
                {
                    tabPageMin=1;
                    tabPageMax = tabPageSize*2+1;
                }
            }
            else
            {
                tabPageMin=1;
                tabPageMax=pageCount;
            }
            %>
            <ul>
                <li><a href="javascript:void(0);" onclick="page(1)">«</a></li>
            <%for (var i = tabPageMin; i <= tabPageMax; i++){ %>
                <%if (pageIndex == i){ %>
                <li class="active"><a href="#"><%=i %></a></li>
                <%}else{ %>
                <li><a href="javascript:void(0);" onclick="javascript:on_page(<%=i %>)"><%=i %></a></li>
                <%} %>
            <%} %>
                <li><a href="javascript:void(0);" onclick="javascript:on_page(<%=pageCount %>)">»</a></li>
            </ul>
        </div>
</asp:Content>
