﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.AccountSendRegistrationMailModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">注册</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            <%if (Model.VCEnabled) { %>
            function updateseccode() {
                var rand = Math.random();
                $('#VC').val('');
                $('#vcimg').attr("src","<%=Url.Action("ValidateCode", "Handler")%>?key=register&_="+rand);

                $('#VC').focus();
            }
            updateseccode();
        
            $('#vcimg').click(function() {
                updateseccode();
                $('#VC').focus();
            });
            $('#vcimgc').click(function() {
                updateseccode();
                $('#VC').focus();
                return false;
            });
            <%} %>
            $("#post").bind("submit", function() {
                easyDialog.open({container : {content : '正在注册...'}});
            });
            //提交
            $("button[name='Cancel']").click(function(){
                top.location.href="<%=Model.Url %>";
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel login_panel">
        <div class="box_panel_title clearfix">
            <div class="fl"><%=Html.Lang("account.register.title")%></div>
            <div class="fr"><a href="<%=Url.Action("Login","Account") %>">已有帐号？现在登录</a></div>
        </div>
        <%if (Model.OAuthList.Length>0){ %>
            <div class="box_panel_context form_panel_a button_bar clearfix">
                <ul>
                    <%for (var i = 0; i < Model.OAuthList.Length;i++ ){ %>
                        <li>
                            <a href="<%=Url.Action("OAuthLogin", "Account", new {key=Model.OAuthList[i].Key,url=Model.Url,act="login" })%>">
                                <%if(!string.IsNullOrEmpty(Model.OAuthList[i].Icon)){ %>
                                    <img src="<%=Model.OAuthList[i].Icon %>" alt="<%=Html.Encode(Model.OAuthList[i].Name) %>" title="<%=Html.Encode(Model.OAuthList[i].Name) %>" />
                                <%}else{ %>
                                    <%=Model.OAuthList[i].Name %>
                                <%} %>
                            </a>
                        </li>
                    <%} %>
                </ul>
            </div>
        <%} %>
        <div class="box_panel_context form_panel_a">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <%= Html.ValidationSummary(false,string.Empty, new { @class = "error_panel" })%>
                <dl>
                    <dt><%=Html.Lang("account.register.email")%>:</dt>
                    <dd class="tip">
                        您将通过收取Email来完成注册
                    </dd>
                    <dd>
                        <%= Html.TextBox("email", Model.Email, new { size = "40", @class = "text"+(Html.HasValidationMessage("email")?" error":"") })%>
                    </dd>
                    <%if (Model.VCEnabled) { %>
                        <dt><%=Html.Lang("account.register.vc")%>:</dt>
                        <dd>
                            <%= Html.TextBox("vc", Model.VC, new { size = "4", style = @"text-transform:uppercase;", @class = "vc text"+(Html.HasValidationMessage("vc")?" error":""), value = string.Empty })%>

                            <div class="description">
                                <%=Html.Lang("account.register.vc_description")%><br />
                                <img id="vcimg" src="<%=ResolveUrl("../../images/loading.gif")%>" alt="Loading" /><br />
                                <a href="#" id="vcimgc"><%=Html.Lang("account.register.vc_refresh")%></a>
                            </div>
                        </dd>
                    <%} %>
                    <dd class="button_panel clearfix">
                        <ul>
                            <li><button type="submit" name="Ok" class="button skyblue"><%=Html.Lang("account.register.reg")%></button></li>
                            <li><button type="button" name="Cancel" class="button"><%=Html.Lang("account.register.cancel")%></button></li>
                        </ul>
                    </dd>
                </dl>
            </form>
        </div>
    </div>
</asp:Content>