﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.BoardShowModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
    <%=Model.Board.Name %>
</asp:Content>
<asp:Content ContentPlaceHolderID="RenderPointTop" runat="server">
    <%=RenderPluginPoint("board.show.top") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="RenderPointBottom" runat="server">
    <%=RenderPluginPoint("board.show.bottom") %>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <%=Html.Partial("PageTopAd", Model.Advertisements, null) %>
    
    

    <div class="box_panel box_panel__color_easy sp board_rule_panel">
        <div class="board_rule_panel_title clearfix">
            <div class="fl">
                <ul class="clearfix">
                    <li><h2><%=Model.Board.Name %></h2></li>
                    <li class="board_rule_panel_count">
                        今日：<strong><%=Model.Board.TodayTopicCount %></strong>
                        <samp>|</samp>
                        主题：<cite><%=Model.Board.TopicCount %></cite>
                        <samp>|</samp>
                        回复：<cite><%=Model.Board.PostCount %></cite>
                    </li>
                </ul>
            </div>
            <div class="fr">
                <ul class="clearfix">
                    <li class="board_rule_panel_favorite"><a href="<%=Url.Action("Favorite","Board",new{bid=Model.Board.Id}) %>">收藏本版</a></li>
                    <li class="board_rule_panel_rss"><a href="<%=Url.SiteAction("RSS","Home",new{bid=Model.Board.Id}) %>" target="_blank">RSS</a></li>
                </ul>
            </div>
        </div>
        <% if (!string.IsNullOrEmpty(Model.Board.Description)) {%>
            <div class="sp">
                <%=Model.Board.Description%>
            </div>
        <%} %>
        <%if (Model.Board.Moderators.Count > 0){%>
            <div class="sp master">
                版主:
                <%for (int i = 0; i < Model.Board.Moderators.Count; i++){ %>
                    <%if (i > 0){ %>,<%} %>
                    <a href="<%=Url.SiteAction("Show", "User", new { uid = Model.Board.Moderators[i].UserId })%>"><%=Model.Board.Moderators[i].Username %></a>
                <%} %>
            </div>
        <%} %>
        <%if (!string.IsNullOrEmpty(Model.Board.Rule))
          { %>
            <div class="sp board_rule_panel_message">
                <%=Model.Board.Rule%>
            </div>
        <%} %>
    </div>


    <%if(HasPoint("board.show.side")){ %>
        <div class="board_s clearfix">
            <div class="board_side clearfix"><%=RenderPluginPoint("board.show.side") %></div>
            <div class="board_content clearfix">
    <%} %>

    <%if (Model.Boards.Count>0){ %>
        <div class="box_panel list_panel sp board_panel">
            <div class="box_panel_title">
                <%=Model.Board.Name %> 子版块
            </div>
            <div class="box_panel_context">
                <div class="list_panel_cut">
                    <%=Html.Partial("BoardList", Model.Board,  new ViewDataDictionary() {{"main_key","board.show.subboard"} }) %>
                </div>
            </div>
        </div>
    <%} %>

    <%if (Model.ShowTopic) { %>
        <div class="sp clearfix">
            <%if(Model.CanCreateTopic || (!Model.CanCreateTopic && User.Id==0) || Model.OperateTopic.OperateBatch){ %>
                <div class="button_panel fl">
                    <ul>
                        <%if(Model.CanCreateTopic){ %>
                            <li>
                                <a href="<%=Url.Action("Create","Topic",new{bid=Model.Board.Id}) %>"><img src="<%=ResolveUrl("../../images/post_button.png")%>" alt="发帖" /></a>
                            </li>
                        <%}else{ %>
                            <%if (User.Id == 0) { %>
                                <li>
                                    <span class="no_ct">
                                        您所在分组(<strong><%=Group.Name %></strong>)无法在此版发表主题
                                            ，您可以进行<a href="<%=Url.Action("Login","Account") %>">登录</a>或<a href="<%=Url.Action("Register","Account") %>">注册</a>
                                    </span>
                                </li>
                            <%} %>
                        <%} %>
                        <%if (Model.OperateTopic.OperateBatch){ %>
                            <li class="mypop" data-pop-id="manage_panel">
                                <a href="javascript:void(0);"><img src="<%=ResolveUrl("../../images/manage_button.png")%>" alt="管理" /></a>
                            </li>
                        <%} %>
                    </ul>
                </div>
            <%} %>
            <div class="page_panel fr">
                <%=Html.PagePartial(Model.PageState.PageIndex, Model.PageState.PageCount)%>
            </div>
        </div>
        <%if(Model.Audited>0){ %>
            <div class="gginfo sp">
                <a href="<%=Url.Action("WTopics", "My", new {bid=Model.BoardId })%>">您在本版中有 <strong><%=Model.Audited %></strong> 条等待审核的主题</a>
            </div>
        <%} %>
        <div class="box_panel sp topic_list_panel">
            <div class="box_panel_title clearfix">
                <div class="fl">
                    <%=Model.Board.Name%>
                </div>
                <ul class="fr">
                    <li<%if (Model.Type==0) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board", new { bid = Model.BoardId }) %>">全部</a></li>
                    <li<%if (Model.Type==1) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board",new { bid = Model.BoardId, type = 1}) %>">最新</a></li>
                    <li<%if (Model.Type==2) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board",new{ bid = Model.BoardId, type = 2 }) %>">精华</a></li>
                </ul>
            </div>
            <div class="box_panel_context">
                <%if (Model.TopicTypes.Any()){ %>
                    <div class="topic_type clearfix">
                        <ul>
                            <li<%if (Model.Type==0) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board", new { bid = Model.BoardId }) %>">全部</a></li>
                            <%foreach (var t in Model.TopicTypes) { %>
                                <li<%if (Model.Type==3 && Model.TopicType==t.Id) {%> class="current"<%} %>>
                                    <a href="<%=Url.SiteAction("Show", "Board",new { bid=Model.BoardId,type=3,topicType=t.Id}) %>">
                                        <%=t.Name%>
                                    </a>
                                </li>
                            <%} %>
                        </ul>
                    </div>
                <%} %>
                <form method="post" name="moderate" action="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>">
                    <input type="hidden" name="bid" value="<%=Model.Board.Id%>" />
                    <input type="hidden" name="url" value="<%=Html.AttributeEncode(Request.RawUrl)%>" />
                    
                    <%if (Model.OperateTopic.OperatePop){ %>
                        <div id="manage_panel" class="pop_panel manage_pop_panel">
	                        <div class="content">
                                <%if (Model.OperateTopic.OperateBatch){ %>
                                    <h3>批量主题管理</h3>
                                    <ul>
                                        <li>
                                            <input id="topic_select_all" type="checkbox" class="select_all" />
                                            <label for="topic_select_all">全选</label>
                                        </li>
                                    </ul>
                                    <ul>
                                        <%if(Model.OperateTopic.Top){ %><li><a href="<%=Url.Action("Top", "Topic") %>" class="manage_action">置顶/解除置顶</a></li><%} %>
                                        <%if(Model.OperateTopic.Digest){ %><li><a href="<%=Url.Action("Digest", "Topic") %>" class="manage_action">加入/解除精华</a></li><%} %>
                                        <%if(Model.OperateTopic.Close){ %><li><a href="<%=Url.Action("Close", "Topic") %>" class="manage_action">关闭/打开主题</a></li><%} %>
                                        <%if(Model.OperateTopic.HighLight){ %><li><a href="<%=Url.Action("HighLight", "Topic") %>" class="manage_action">高亮显示</a></li><%} %>
                                        <%if(Model.OperateTopic.Ban){ %><li><a href="<%=Url.Action("Ban", "Topic") %>" class="manage_action">主题屏蔽</a></li><%} %>
                                        <%if(Model.OperateTopic.Delete){ %><li><a href="<%=Url.Action("Delete", "Topic") %>" class="manage_action">删除主题</a></li><%} %>
                                        <%if(Model.OperateTopic.Move){ %><li><a href="<%=Url.Action("Move", "Topic") %>" class="manage_action">移动主题</a></li><%} %>
                                        <%if(Model.OperateTopic.Type){ %><li><a href="<%=Url.Action("Type", "Topic") %>" class="manage_action">主题分类</a></li><%} %>
                                    </ul>
                                <%} %>
                                <%if (Model.OperateTopic.OperatePanel){ %>
                                    <h3>版块综合管理</h3>
                                    <ul>
                                        <%if(Model.OperateTopic.MTopicAudit){ %><li><a href="<%=Url.Action("WTopics", "Management", new { bid=Model.Board.Id}) %>">主题审核</a></li><%} %>
                                        <%if(Model.OperateTopic.MReplyAudit){ %><li><a href="<%=Url.Action("WReplys", "Management", new { bid=Model.Board.Id})%>">回复审核</a></li><%} %>
                                    </ul>
                                <%} %>
                            </div>
                        </div>
        
                        <div id="manageTopic" class="box_panel box_panel__color_easy post_manage_panel">
                            <div class="box_panel_title clearfix">
                                <div class="fl">选择了<span id="manageTopicCount">0</span>个主题</div>
                                <div class="fr">
                                    <input id="flex_post_select_all" type="checkbox" class="select_all" />
                                    <label for="flex_post_select_all">全选</label>
                                    <span class="pipe">|</span>
                                    <span class="select_all_cancel">取消</span>
                                </div>
                            </div>
                            <div class="box_panel_context">
                                <ul>
                                    <%if(Model.OperateTopic.Top){ %><li><a href="<%=Url.Action("Top", "Topic") %>" class="manage_action">置顶/解除置顶</a></li><%} %>
                                    <%if(Model.OperateTopic.Digest){ %><li><a href="<%=Url.Action("Digest", "Topic") %>" class="manage_action">加入/解除精华</a></li><%} %>
                                    <%if(Model.OperateTopic.Close){ %><li><a href="<%=Url.Action("Close", "Topic") %>" class="manage_action">关闭/打开主题</a></li><%} %>
                                    <%if(Model.OperateTopic.HighLight){ %><li><a href="<%=Url.Action("HighLight", "Topic") %>" class="manage_action">高亮显示</a></li><%} %>
                                    <%if(Model.OperateTopic.Ban){ %><li><a href="<%=Url.Action("Ban", "Topic") %>" class="manage_action">主题屏蔽</a></li><%} %>
                                    <%if(Model.OperateTopic.Delete){ %><li><a href="<%=Url.Action("Delete", "Topic") %>" class="manage_action">删除主题</a></li><%} %>
                                    <%if(Model.OperateTopic.Move){ %><li><a href="<%=Url.Action("Move", "Topic") %>" class="manage_action">移动主题</a></li><%} %>
                                    <%if(Model.OperateTopic.Type){ %><li><a href="<%=Url.Action("Type", "Topic") %>" class="manage_action">主题分类</a></li><%} %>
                                </ul>
                            </div>
                        </div>
                    <%} %>
                    <%if(Model.TopTopics.Count>0 || Model.Topics.Count>0){ %>
                        <%if(Model.PicListStyle!=null){ %>
                            <div class="topic_image_list">
                                <ul class="clearfix">
                                    <%foreach (var Topic in Model.TopTopics){ %>
                                        <li style="width:<%=Model.PicListStyle.Width %>px;">
                                            <%if (Model.OperateTopic.OperateBatch){%>
                                                <div class="se">
                                                    <input type="checkbox"<%if (Topic.BoardId!=Model.Board.Id){%> disabled<%} %> value="<%=Topic.Id%>" name="tids"/>
                                                </div>
                                            <%} %>
                                            <div class="pic">
                                                <a href="<%=Url.SiteAction("Show", "Topic", new { tid=Topic.Id})%>" title="<%=Html.Encode(Topic.Title)%>">
                                                <%if (Topic.Cover){ %>
                                                    <img src="<%=Topic.CoverUrl %>" width="<%=Model.PicListStyle.Width %>" height="<%=Model.PicListStyle.Height %>" alt="<%=Html.Encode(Topic.Title)%>" />
                                                <%}else{ %>
                                                    <span class="nopic" style="width:<%=Model.PicListStyle.Width %>px;height:<%=Model.PicListStyle.Height %>px;"></span>
                                                <%} %>
                                                </a>
                                            </div>
                                            <div class="tit" style="width:<%=Model.PicListStyle.Width %>px;">
                                                <a href="<%=Url.SiteAction("Show", "Topic", new { tid=Topic.Id})%>" title="<%=Html.Encode(Topic.Title)%>">
                                                    <%if (string.IsNullOrEmpty(Topic.HighLight)){ %>
                                                        <%=Html.Encode(Topic.Title)%>
                                                    <%}else{ %>
                                                        <span style="<%=Topic.HighLight%>">
                                                            <%=Html.Encode(Topic.Title)%>
                                                        </span>
                                                    <%} %>
                                                </a>
                                            </div>
                                            <div class="author clearfix">
                                                <span class="eex">
                                                    <%if (!string.IsNullOrEmpty(Topic.PostUsername)){ %>
                                                        <%if(string.IsNullOrEmpty(Topic.PostHighLight)){ %>
                                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = Topic.PostUserId })%>"><%=Topic.PostUsername %></a>
                                                        <%}else{ %>
                                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = Topic.PostUserId })%>"><span style="<%=Topic.PostHighLight%>"><%=Topic.PostUsername %></span></a>
                                                        <%} %>
                                                    <%}else{ %>
                                                        -
                                                    <%} %>
                                                </span>
                                                <span class="ex">
                                                    <%if (Topic.IconKey.StartsWith("top_", StringComparison.OrdinalIgnoreCase)) { %>
                                                        [顶]
                                                    <%}else if(Topic.IconKey.Equals("digest",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [精]
                                                    <%}else if(Topic.IconKey.Equals("lock",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [锁]
                                                    <%}else if(Topic.IconKey.Equals("hot",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [热]
                                                    <%}else if(Topic.IconKey.Equals("new",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [新]
                                                    <%} %>
                                                </span>
                                            </div>
                                            <div class="description clearfix">
                                                <span class="dt" title="<%=Html.ForumTime(Topic.LastPostDatetime).ToString("yyyy-MM-dd HH:mm") %>"><%=Html.FriendlyTime(Topic.LastPostDatetime) %></span>
                                                <span class="vr"><%=Topic.ReplayCount %>/<%=Topic.ViewCount %></span>
                                            </div>
                                        </li>
                                    <%} %>
                                    <%foreach (var Topic in Model.Topics){ %>
                                        <li style="width:<%=Model.PicListStyle.Width %>px;">
                                            <%if (Model.OperateTopic.OperateBatch){%>
                                                <div class="se">
                                                    <input type="checkbox"<%if (Topic.BoardId!=Model.Board.Id){%> disabled<%} %> value="<%=Topic.Id%>" name="tids"/>
                                                </div>
                                            <%} %>
                                            <div class="pic">
                                                <a href="<%=Url.SiteAction("Show", "Topic", new { tid=Topic.Id})%>" title="<%=Html.Encode(Topic.Title)%>">
                                                <%if (Topic.Cover){ %>
                                                    <img src="<%=Topic.CoverUrl %>" width="<%=Model.PicListStyle.Width %>" height="<%=Model.PicListStyle.Height %>" alt="<%=Html.Encode(Topic.Title)%>" />
                                                <%}else{ %>
                                                    <span class="nopic" style="width:<%=Model.PicListStyle.Width %>px;height:<%=Model.PicListStyle.Height %>px;"></span>
                                                <%} %>
                                                </a>
                                            </div>
                                            <div class="tit" style="width:<%=Model.PicListStyle.Width %>px;">
                                                <a href="<%=Url.SiteAction("Show", "Topic", new { tid=Topic.Id})%>" title="<%=Html.Encode(Topic.Title) %>">
                                                    <%if (string.IsNullOrEmpty(Topic.HighLight)){ %>
                                                        <%=Html.Encode(Topic.Title)%>
                                                    <%}else{ %>
                                                        <span style="<%=Topic.HighLight%>">
                                                            <%=Html.Encode(Topic.Title)%>
                                                        </span>
                                                    <%} %>
                                                </a>
                                            </div>
                                            <div class="author clearfix">
                                                <span class="eex">
                                                    <%if (!string.IsNullOrEmpty(Topic.PostUsername)){ %>
                                                        <%if(string.IsNullOrEmpty(Topic.PostHighLight)){ %>
                                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = Topic.PostUserId })%>"><%=Topic.PostUsername %></a>
                                                        <%}else{ %>
                                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = Topic.PostUserId })%>"><span style="<%=Topic.PostHighLight%>"><%=Topic.PostUsername %></span></a>
                                                        <%} %>
                                                    <%}else{ %>
                                                        -
                                                    <%} %>
                                                </span>
                                                <span class="ex">
                                                    <%if(Topic.IconKey.StartsWith("top_",StringComparison.OrdinalIgnoreCase)){ %>
                                                        [顶]
                                                    <%}else if(Topic.IconKey.Equals("digest",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [精]
                                                    <%}else if(Topic.IconKey.Equals("lock",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [锁]
                                                    <%}else if(Topic.IconKey.Equals("hot",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [热]
                                                    <%}else if(Topic.IconKey.Equals("new",StringComparison.OrdinalIgnoreCase)){  %>
                                                        [新]
                                                    <%} %>
                                                </span>
                                            </div>
                                            <div class="description clearfix">
                                                <span class="dt" title="<%=Html.ForumTime(Topic.LastPostDatetime).ToString("yyyy-MM-dd HH:mm") %>"><%=Html.FriendlyTime(Topic.LastPostDatetime) %></span>
                                                <span class="vr"><%=Topic.ReplayCount %>/<%=Topic.ViewCount %></span>
                                            </div>
                                        </li>
                                    <%} %>
                                </ul>
                            </div>
                        <%}else{ %>
                            <div class="list_panel">
                                <table>
                                    <thead>
                                        <tr>
                                            <td colspan="2" class="title">
                                                标题
                                            </td>
                                            <td class="author">作者</td>
                                            <td class="nums">回复/查看</td>
                                            <td class="last">最后发表</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <%for (int topic_index = 0; topic_index < Model.TopTopics.Count; topic_index++){ %>
                                            <%var topic = Model.TopTopics[topic_index]; %>
                                            <tr>
                                                <td class="icon">
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" target="_blank">
                                                        <img src="<%=ResolveUrl("../../images/topic_state_"+topic.IconKey+".gif") %>" title="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" alt="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" />
                                                    </a>
                                                </td>
                                                <td class="title clearfix">
                                                    <%if (Model.OperateTopic.OperateBatch){%>
                                                        <input type="checkbox"<%if (topic.BoardId!=Model.Board.Id){%> disabled="disabled"<%} %> value="<%=topic.Id%>" name="tids"/>
                                                    <%} %>
                                                    <%if (topic.Ban > 0){ %>
                                                        <del>
                                                            <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>" title="<%=Html.Encode(topic.Title)%>"> 
                                                                <%if (Model.IsAdmin){ %>
                                                                    <%if (string.IsNullOrEmpty(topic.HighLight)){ %>
                                                                        <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                    <%}else{ %>
                                                                        <span style="<%=topic.HighLight%>">
                                                                            <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                        </span>
                                                                    <%} %>
                                                                <%}else{ %>
                                                                此主题已经被管理人员屏蔽
                                                                <%} %>
                                                            </a>
                                                        </del>
                                                    <%}else{ %>
                                                        <span class="topic_title">
                                                            <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>" title="<%=Html.Encode(topic.Title)%>">
                                                                <%if (string.IsNullOrEmpty(topic.HighLight)){ %>
                                                                    <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                <%}else{ %>
                                                                    <span style="<%=topic.HighLight%>">
                                                                        <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                    </span>
                                                                <%} %>
                                                            </a>
                                                        </span>
                                                    <%} %>
                                                    <%if(topic.Rate!=0){ %>
                                                        <span class="topic_row_rate" title="评分">[<%=topic.Rate>=0?"+":"-" %><%=Math.Abs(topic.Rate).ToString("0.##") %>]</span>
                                                    <%} %>
                                                    <%if (topic.Attachment== (int)EAttachmentType.File){ %>
                                                        <span class="attachment_file" title="附件">[附件]</span>
                                                    <%}else if (topic.Attachment== (int)EAttachmentType.Image){ %>
                                                        <span class="attachment_image" title="图像">[图]</span>
                                                    <%} %>
                                                    <%if(topic.IsReplyNew){ %>
                                                        <span class="topic_new" title="新">[新]</span>
                                                    <%} %>
                                                    <%if (topic.PostCount > Model.PostPageSize){ %>
                                                        <br />
                                                        <span class="topic_pages">
                                                            ...
                                                            <%for (int i = 2; i <= (topic.PostPages < 6 ? topic.PostPages : 6); i++){ %>
                                                                <a href="<%=Url.SiteAction("Show", "Topic", new {tid=topic.Id,page=i })%>"><%=i %></a>
                                                            <%} %>
                                                            <%if (topic.PostPages > 6){ %>
                                                                ..
                                                                <a href="<%=Url.SiteAction("Show", "Topic", new {tid=topic.Id,page=topic.PostPages })%>"><%=topic.PostPages%></a>
                                                            <%} %>
                                                        </span>
                                                    <%} %>
                                                </td>
                                                <td class="author">
                                                    <%=RenderPluginPoint("board.show.top_topics.post_user",topic_index) %>
                                                    <div>
                                                    <cite>
                                                        <%if (!string.IsNullOrEmpty(topic.PostUsername)){ %>
                                                            <%if(string.IsNullOrEmpty(topic.PostHighLight)){ %>
                                                                <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.PostUserId })%>"><%=topic.PostUsername %></a>
                                                            <%}else{ %>
                                                                <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.PostUserId })%>"><span style="<%=topic.PostHighLight%>"><%=topic.PostUsername %></span></a>
                                                            <%} %>
                                                        <%}else{ %>
                                                            -
                                                        <%} %>
                                                    </cite>
                                                    <em title="<%=Html.ForumTime(topic.PostDatetime).ToString("yyyy-MM-dd HH:mm") %>">
                                                        <%=Html.FriendlyTime(topic.PostDatetime) %>
                                                    </em>
                                                    </div>
                                                </td>
                                                <td class="nums">
                                                    <%if (topic.ReplayCount>0){ %>
                                                        <a href="<%=Url.SiteAction( "Show", "Topic", new { tid = topic.Id })%>"><strong><%=topic.ReplayCount%></strong></a>
                                                    <%}else{ %>
                                                        <em><%=topic.ReplayCount%></em>
                                                    <%} %>
                                                    <em><%=topic.ViewCount%></em>
                                                </td>
                                                <td class="last">
                                                    <cite>
                                                        <%if (!string.IsNullOrEmpty(topic.LastPostUsername)){ %>
                                                            <%if(string.IsNullOrEmpty(topic.LastHighLight)){ %>
                                                                <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.LastPostUserId })%>"><%=topic.LastPostUsername %></a>
                                                            <%}else{ %>
                                                                <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.LastPostUserId })%>"><span style="<%=topic.LastHighLight%>"><%=topic.LastPostUsername %></span></a>
                                                            <%} %>
                                                        <%}else{ %>
                                                            -
                                                        <%} %>
                                                    </cite>
                                                    <em title="<%=Html.ForumTime(topic.LastPostDatetime).ToString("yyyy-MM-dd HH:mm") %>"<%if(topic.IsReplyNew) {%> class="hi"<%} %>>
                                                        <a href="<%=Url.SiteAction( "Show", "Topic", new { tid = topic.Id,page="-1" })%>"><%=Html.FriendlyTime(topic.LastPostDatetime) %></a>
                                                    </em>
                                                </td>
                                            </tr>
                                        <%} %>
                                        <%if (Model.Topics.Count > 0 && Model.TopTopics.Count > 0){ %>
                                            </tbody>
                                            <tbody class="sptitle">
                                            <tr>
                                                <td colspan="5">版块主题</td>
                                            </tr>
                                            </tbody>
                                            <tbody>
                                        <%} %>
                                        <%for (int topic_index=0;topic_index<Model.Topics.Count;topic_index++){ %>
                                            <%var topic = Model.Topics[topic_index];%>
                                            <tr>
                                                <td class="icon">
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" target="_blank">
                                                        <img src="<%=ResolveUrl("../../images/topic_state_"+topic.IconKey+".gif") %>" title="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" alt="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" />
                                                    </a>
                                                </td>
                                                <td class="title clearfix">
                                                    <%if (Model.OperateTopic.OperateBatch){%>
                                                        <input type="checkbox"<%if (topic.BoardId!=Model.Board.Id){%> disabled<%} %> value="<%=topic.Id%>" name="tids"/>
                                                    <%} %>
                                                    <%if (topic.Board!=null && topic.BoardId!=Model.BoardId){ %>
                                                        <em>
                                                        <a href="<%=Url.SiteAction("Show","Board",new{bid=topic.BoardId}) %>">[<%=topic.Board.Name %>]</a>
                                                        </em>
                                                    <%} %>
                                                    <%if (topic.TopicType!=null){ %>
                                                        <em>
                                                        <a href="<%=Url.SiteAction("Show","Board",new{bid=topic.BoardId, type=3,topicType=topic.TopicType.Id}) %>">[<%=topic.TopicType.Name%>]</a>
                                                        </em>
                                                    <%} %>
                                                    <%if (topic.Ban > 0){ %>
                                                        <del>
                                                            <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>" title="<%=Html.Encode(topic.Title)%>">
                                                                <%if (Model.IsAdmin){ %>
                                                                        <%if (string.IsNullOrEmpty(topic.HighLight)){ %>
                                                                            <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                        <%}else{ %>
                                                                            <span style="<%=topic.HighLight%>">
                                                                                <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                            </span>
                                                                        <%} %>
                                                                <%}else{ %>
                                                                    此主题已经被管理人员屏蔽
                                                                <%} %>
                                                            </a>
                                                        </del>
                                                    <%}else{ %>
                                                        <span class="topic_title">
                                                            <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>" title="<%=Html.Encode(topic.Title)%>">
                                                                <%if (string.IsNullOrEmpty(topic.HighLight)){ %>
                                                                    <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                <%}else{ %>
                                                                    <span style="<%=topic.HighLight%>">
                                                                        <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                    </span>
                                                                <%} %>
                                                            </a>
                                                        </span>
                                                    <%} %>
                                                    <%if(topic.Rate!=0){ %>
                                                        <span class="topic_row_rate" title="评分">[<%=topic.Rate>=0?"+":"-" %><%=Math.Abs(topic.Rate).ToString("0.##") %>]</span>
                                                    <%} %>
                                                    <%if (topic.Attachment== (int)EAttachmentType.File){ %>
                                                        <span class="attachment_file" title="附件">[附件]</span>
                                                    <%}else if (topic.Attachment== (int)EAttachmentType.Image){ %>
                                                        <span class="attachment_image" title="图像">[图]</span>
                                                    <%} %>
                                                    <%if(topic.IsReplyNew){ %>
                                                        <span class="topic_new" title="新">[新]</span>
                                                    <%} %>
                                                    <%if (topic.PostCount > Model.PostPageSize){ %>
                                                        <span class="topic_pages">
                                                            ...
                                                            <%for (int i = 2; i <= (topic.PostPages < 6 ? topic.PostPages : 6); i++){ %>
                                                                <a href="<%=Url.SiteAction("Show", "Topic", new {tid=topic.Id,page=i })%>"><%=i %></a>
                                                            <%} %>
                                                            <%if (topic.PostPages > 6){ %>
                                                                ..
                                                                <a href="<%=Url.SiteAction("Show", "Topic", new {tid=topic.Id,page=topic.PostPages })%>"><%=topic.PostPages%></a>
                                                            <%} %>
                                                        </span>
                                                    <%} %>
                                                </td>
                                                <td class="author">
                                                    <%=RenderPluginPoint("board.show.topics.post_user",topic_index) %>
                                                    <div>
                                                    <cite>
                                                        <%if (!string.IsNullOrEmpty(topic.PostUsername)){ %>
                                                            <%if(string.IsNullOrEmpty(topic.PostHighLight)){ %>
                                                                <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.PostUserId })%>"><%=topic.PostUsername %></a>
                                                            <%}else{ %>
                                                                <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.PostUserId })%>"><span style="<%=topic.PostHighLight%>"><%=topic.PostUsername %></span></a>
                                                            <%} %>
                                                        <%}else{ %>
                                                            -
                                                        <%} %>
                                                    </cite>
                                                    <em title="<%=Html.ForumTime(topic.PostDatetime).ToString("yyyy-MM-dd HH:mm") %>">
                                                        <%=Html.FriendlyTime(topic.PostDatetime) %>
                                                    </em>
                                                    </div>
                                                </td>
                                                <td class="nums">
                                                    <%if (topic.ReplayCount>0){ %>
                                                        <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>"><strong><%=topic.ReplayCount%></strong></a>
                                                    <%}else{ %>
                                                        <em><%=topic.ReplayCount%></em>
                                                    <%} %>
                                                    <em><%=topic.ViewCount%></em>
                                                </td>
                                                <td class="last">
                                                    <cite>
                                                    <%if (!string.IsNullOrEmpty(topic.LastPostUsername)){ %>
                                                        <%if(string.IsNullOrEmpty(topic.LastHighLight)){ %>
                                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.LastPostUserId })%>"><%=topic.LastPostUsername %></a>
                                                        <%}else{ %>
                                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = topic.LastPostUserId })%>"><span style="<%=topic.LastHighLight%>"><%=topic.LastPostUsername %></span></a>
                                                        <%} %>
                                                    <%}else{ %>
                                                        -
                                                    <%} %>
                                                    </cite>
                                                    <em title="<%=Html.ForumTime(topic.LastPostDatetime).ToString("yyyy-MM-dd HH:mm") %>"<%if(topic.IsReplyNew) {%> class="hi"<%} %>>
                                                        <a href="<%=Url.SiteAction( "Show", "Topic", new { tid = topic.Id,page="-1" })%>"><%=Html.FriendlyTime(topic.LastPostDatetime) %></a>
                                                    </em>
                                                </td>
                                            </tr>
                                        <%} %>
                                    </tbody>
                                </table>
                            </div>
                        <%} %>
                    <%}else{ %>
                        <div class="noitem">
                            本版块或指定的范围内尚无主题。
                        </div>
                    <%} %>
                </form>
            </div>
        </div>
        <div class="sp clearfix">
            <div class="order_panel fl">
                <form id="post" method="get" action="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>">
                    <%=Html.Hidden("bid", Model.BoardId)%>
                    <%=Html.Hidden("type", Model.Type)%>
                    <%=Html.Hidden("topictype", Model.TopicType)%>
                    排序方式
                    <select name="orderfield">
                        <option value="1"<%=Model.OrderState.OrderField==1?" selected=\"selected\"":"" %>>最后回复时间</option>
                        <option value="2"<%=Model.OrderState.OrderField==2?" selected=\"selected\"":"" %>>发布时间</option>
                    </select>
                    <select name="order">
                        <option value="1"<%=Model.OrderState.Order==1?" selected=\"selected\"":"" %>>按降序排列</option>
                        <option value="2"<%=Model.OrderState.Order==2?" selected=\"selected\"":"" %>>按升序排列</option>
                    </select>
                    <button type="submit" value="1">提交</button>
                </form>
            </div>
            <div class="page_panel fr">
                <%=Html.PagePartial(Model.PageState.PageIndex, Model.PageState.PageCount)%>
            </div>
        </div>
    <%}// Topic List %>

    <%if(HasPoint("side")){ %>
            </div>
        </div>
    <%} %>
</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="FootContent" runat="server">
    <%if (Model.ShowTopic && Model.OperateTopic.OperateBatch) { %>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {

            $(".mypop").ExPanel();

            $(".manage_action").click(function () {
                var url = $(this).attr("href");
                var formObj = $("form[name='moderate']")[0];
                formObj.action = url;
                formObj.submit();
                return false;
            });
            ManageTopic();

            function ManageTopic() {
                var len = $("[name='tids']:checkbox:enabled:checked").length;
                if (len > 0) {
                    $("#manageTopicCount").html(len);
                    $("#manageTopic").show();
                }
                else {
                    $("#manageTopic").hide();
                }
                $("#manageTopic").css("left", $("#manageTopic").parent().offset().left + ($("#manageTopic").parent().width() - $("#manageTopic").outerWidth(false)) / 2 + "px");
            }

            $("[name='tids']:checkbox:enabled").click(function () {
                if (!$(this)[0].checked)
                    $(".select_all").checked( false);
                else if ($("[name='tids']:checkbox:checked").length == $("[name='tids']:checkbox:enabled").length)
                    $(".select_all").checked( true);

                ManageTopic();
            });

            $(".select_all_cancel").click(function () {
                $(".select_all").checked( false);
                $("[name='tids']:checkbox:checked").checked(false);
                $("#manageTopic").hide();
            });

            $(".select_all").change(function () {
                var selected = $(this)[0].checked;
                $(".select_all").checked(selected);
                $("[name='tids']:checkbox:enabled").checked(selected);
                ManageTopic();
            });
        });
    </script>
    <%} %>
</asp:Content>