﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.AuditPostListModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">主题审核</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        var is_loaded = false;
        function page(p) {
            if (!is_loaded)
            {
                alert('请稍候...正在加载中...');
                return;
            }
            $("#form_page input[name='page']").val(p);
            $("#form_page").submit();
        }
        function action(action,tid) {
            if (!is_loaded) {
                alert('请稍候...正在加载中...');
                return;
            }
            $.ajax({
                url: "<%=Url.Action("WTopics","Handler") %>",
                type: 'POST',
                dataType: 'json',
                data: { action: action,tids:tid },
                async: true,
                cache: false,
                success: function (data) {
                    if (data.error) {
                        alert(data.description);
                        return;
                    }
                    page(<%=Model.PageIndex %>);
                },
                error: function () {
                    alert("服务器通讯失败.");
                }
            });
        }
        $(document).ready(function () {
            is_loaded = true;

            $("[name='tids']:checkbox:enabled").click(function () {
                if (!$(this)[0].checked)
                    $("[name='tids_all']").checked(false);
                else if ($("[name='tids']:checkbox:checked").length == $("[name='tids']:checkbox:enabled").length)
                    $("[name='tids_all']").checked(true);
            });
            $("[name='tids_all']").change(function () {
                var selected = $(this)[0].checked;
                $("[name='tids_all']").checked(selected);
                $("[name='tids']:checkbox:enabled").checked(selected);
            });

            $("#form_operate").ajaxForm({
                beforeSubmit: function (formData, jqForm, options) {
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        alert(data.description);
                        return;
                    }
                    page(<%=Model.PageIndex %>);
                },
                error: function () {
                    alert("服务器通讯失败.");
                },
                url: "<%=Url.Action("WTopics","Handler") %>",
                type: 'post',
                dataType: 'json'
            });
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    

    <form id="form_page" action="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>" method="get">
        <input name="page" type="hidden" value="<%=Model.PageIndex %>" />
        <input name="bid" type="hidden" value="<%=Model.FormBoardId %>" />
        <input name="audit" type="hidden" value="<%=Model.FormAudit %>" />
    </form>

    <form id="form_search" action="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>" method="get">
        <div class="sp">
            版块:
            <select name="bid">
                <option value="0">全部</option>
                <%foreach(var board in Model.Boards){ %>
                <option value="<%=board.Id %>"<%if(Model.FormBoardId==board.Id){ %> selected="selected"<%} %>><%=board.Name %></option>
                <%} %>
            </select>
            帖子范围:
            <select name="audit">
                <option value="1"<%if(Model.FormAudit==1){ %> selected="selected"<%} %>>待审核</option>
                <option value="2"<%if(Model.FormAudit==2){ %> selected="selected"<%} %>>已忽略</option>
            </select>
            <button type="submit">查询</button>
        </div>
    </form>
    
    <form id="form_operate" action="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>" method="post">
        <input name="url" type="hidden" value="<%=Html.AttributeEncode(Request.Url.AbsoluteUri) %>" />
        <div class="box_panel sp">
            <div class="box_panel_title">
               主题审核
            </div>
            <div class="box_panel_context">
                <div class="list_panel list_panel_cut">
                    <%if (Model.Items.Any()){ %>
                        <%foreach (var item in Model.Items){ %>
                            <div style="border-top: 1px dashed #CDCDCD;padding:10px;">
                                <div class="clearfix">
                                    <div class="fl">
                                        <input type="checkbox" name="tids" value="<%=item.TopicId %>" />
                                        <a href="<%=Url.SiteAction("Show","Board",new{bid=item.BoardId}) %>" target="_blank">[<%=item.BoardName%>]</a>
                                        <a href="<%=Url.SiteAction("Show","Topic",new{tid=item.TopicId}) %>" target="_blank" title="<%=Html.Encode(item.Title)%>">
                                            <%=Html.Encode(item.Title) %>
                                        </a>
                                    </div>
                                    <div class="fr">
                                        <%if (item.PostUserId>0 && !string.IsNullOrEmpty(item.PostUsername)){ %>
                                            <a href="<%=Url.SiteAction( "Show", "User", new { uid = item.PostUserId })%>"><%=item.PostUsername %></a>
                                        <%}else{ %>
                                            -
                                        <%} %>
                                        于
                                        <a href="javascript:void(0);" title="<%=Html.ForumTime(item.PostDatetime).ToString("yyyy-MM-dd HH:mm") %>">
                                            <%=Html.FriendlyTime(item.PostDatetime, "yyyy-MM-dd HH:mm") %>
                                        </a>
                                        发布
                                    </div>
                                </div>
                                <div class="sp" style="border:1px solid #eee;height:50px;overflow:auto;padding:10px;">
                                    <%=item.Message %>
                                </div>
                                <!--
                                <div class="clearfix sp">
                                    <div class="fr">
                                        <a href="javascript:action(1,<%=item.TopicId %>);">通过</a>
                                        <span class="pipe">|</span>
                                        <a href="javascript:action(2,<%=item.TopicId %>);">忽略</a>
                                        <span class="pipe">|</span>
                                        <a href="javascript:action(3,<%=item.TopicId %>);">删除</a>
                                    </div>
                                </div>
                                -->
                            </div>
                        <%} %>
                    <%}else{ %>
                        <div class="noitem">
                            无任何可操作项
                        </div>
                    <%} %>
                </div>
            </div>
        </div>
    
        <div class="sp clearfix">
            <div class="fl">
                <label>
                    <input type="checkbox" name="tids_all" />
                    全选
                </label>
                <button name="action" type="submit" value="1">通过</button>
                <%if(Model.FormAudit==1){ %>
                <button name="action" type="submit" value="2">忽略</button>
                <%} %>
                <button name="action" type="submit" value="3">删除</button>
            </div>
            <div class="page_panel fr">
                <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
            </div>
        </div>
    </form>



</asp:Content>